/*
 This file is part of Adamant Armor Affection.

    Adamant Armor Affection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Adamant Armor Affection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Adamant Armor Affection.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "vars.h"
#include "zmath.h"
//0 - enabled
//1 - sprite
//2 - x
//3 - y
//4 - rx
//5 - ry
//6 - ix
//7 - iy
//8 - hp
//9 - ai
//10 - flip
//11 - zerosprite
//12 - height
//13 - aanimation
//14 - ID
//15 - bashcount

//
void HurtMob(unsigned char i)
{
    mob[i][13]=0;
    if (mob[i][15]==0)
    {
        if (mob[i][8]>0)
        {
            mob[i][8]--;
            if (mob[i][8]) {
                mob[i][15]=5;
                PlaySound(4,0);
                mob[i][9]=70;
            }
            else
            {
                PlaySound(5,0);
            }
        }
    }
}
void MobBite(Uint8 i)
{
    Uint8 k;
    if (i==0)
    {
        for (k=1; k<64; k++)
            if (mob[k][8]>0)
                if (mob[k][0])
                    if (zabs(mob[0][2]-mob[k][2])<28)
                        if (zabs(mob[0][3]-mob[k][3])<14)
                            HurtMob(k);
    }
    else
    {
        if (mob[0][8]>0)
            if (mob[0][0])
                if (zabs(mob[0][2]-mob[i][2])<28)
                    if (zabs(mob[0][3]-mob[i][3])<14)
                        HurtMob(0);
    }

}


Uint8 blocked[16]=
{
    0,0,0,0,
    0,0,0,0,
    0,0,0,0,
    1,1,0,1

};

Uint8 ffmob(Sint32 tx,Sint32 ty,Uint8 index)
{
    Uint8 rs=0;
    Sint32 cx,cy;
    cx=tx>>16;
    cy=ty>>16;
    cx=cx/2;
    if (cx>8)
        if (cx<1990)
            if (cy>16)
                if (cy<120)
                    rs=1;
    if (rs)
    {
        Uint32 ii,x,y;

        ii=cx-2+(cy-mob[index][12])*2000;
        for (y=0; y<mob[index][12]; y++)
        {
            for (x=0; x<4; x++)
            {
                if (blocked[leveltg[ii]]) rs=0;
                ii++;
            }
            ii+=1996;
        }
    }

    return rs;
}

void MobShoot(Uint8 i)
{
    Uint8 b=0;
    while ((bullet[b][0]>0)&(b<32)) b++;
    if (b<32)
    {
        PlaySound(6,0);
        bullet[b][0]=1;
        bullet[b][1]=mob[i][10];
        bullet[b][2]=mob[i][2]+20-40*mob[i][10];
        bullet[b][3]=mob[i][3]-10+random4();
        bullet[b][4]=i;
    }
}


//ai
//0 stand still
//50 walks
//100 see enemy

Uint8 seeplayer(Uint8 i)
{
    Uint8 rt=1;
    if (mob[i][2]>mob[0][2])
    {
        if (mob[i][10]==0) rt=0;
    }
    else if (mob[i][10]==1) rt=0;

    Sint32 range=zabs(mob[i][2]-mob[0][2]);
    if (range>140) rt=0;
    if (playerstate==1)
        if (range>50) rt=0;

    if (rt)
    {
        Uint8 k;
        Sint32 x,y,ii;
        for (k=1; k<22; k++)
        {
            x=mob[i][2]+(mob[0][2]-mob[i][2])*k/25;
            y=-7+mob[i][3]+(mob[0][3]-mob[i][3])*k/25;
            x=x>>1;
            ii=x+y*2000;

            if (blocked[leveltg[ii]]) rt=0;
        }

    }
    return rt;
}

Sint32 mspeeds[18][2]=
{
    {0,0},{0,0},{0,0},{0,0},
    {4,-12},{4,12},//0
    { 5,12},{2,15},//1
    { 3,12},{4 ,10},//2
    { 4,12},{1 ,18},//3
    { 4,15},{10,10},//4
    {10,10},{1 ,10},//5
    {10,10},{10,10} //6
};//mspeeds[mob[i][14]][0]
Uint8 mshoot[18]=
{
    0,0,1,1,
    0,1,
    1,1,
    0,0,
    0,0,
    0,0,
    0,0
};

Uint8 turndata[64],oldturndata[64];

void ProcAi(Uint8 i)
{

    Sint32 speed=mspeeds[mob[i][14]][0]*10000;
    if (seeplayer(i)) {
        mob[i][9]=100;
    }
    if (mob[i][15]==0)
        if (mob[i][9]>0)
        {
            if (mob[i][9]==98)
                if (ffmob(mob[i][4],mob[i][5]+165536,i)==0)
                    mob[i][7]-=400000;
            if (mob[i][9]>70)
                if (mob[0][2]>mob[i][2]) mob[i][10]=0;
                else mob[i][10]=1;

            if (mob[i][9]>98)
            {
                if (mshoot[mob[i][14]])
                {
                    if (count % 30==i %30)
                        MobShoot(i);
                }
                else if (zabs(mob[0][2]-mob[i][2])<25)
                    if (zabs(mob[0][3]-mob[i][3])<14)
                    {
                        mob[i][13]=16;
                    }


            }



            if (mob[i][9]>50)
            {
                speed=10000*mspeeds[mob[i][14]][1];//
                if (ffmob(mob[i][4]+200000-400000*mob[i][10],mob[i][5]+165536,i))
                    if (ffmob(mob[i][4],mob[i][5]+165536,i)==0)
                        mob[i][7]-=400000;

            }
            else
            {


                if (ffmob(mob[i][4]+200000-400000*mob[i][10],mob[i][5]+165536,i)) mob[i][10]=!mob[i][10];
                if (ffmob(mob[i][4]+200000-400000*mob[i][10],mob[i][5]-165536,i)==0) mob[i][10]=!mob[i][10];


                if (random64()==0) mob[i][10]=!mob[i][10];
            }
            if (mob[i][10])
                mob[i][6]-=speed;
            else
                mob[i][6]+=speed;

            mob[i][9]--;
        }
        else if (random32()==0) mob[i][9]=random32()+random16();


    if (oldturndata[i]!=mob[i][10])
    {
        turndata[i]+=4;
        if (turndata[i]>20)
        {
            if (ffmob(mob[i][4],mob[i][5]+165536,i)==0)
                mob[i][7]-=400000;
            speed=10000*mspeeds[mob[i][14]][1];//
            if (mob[i][10])
                mob[i][6]-=speed;
            else
                mob[i][6]+=speed;
            turndata[i]=0;
        }

    }
    if (turndata[i]) turndata[i]--;
    oldturndata[i]=mob[i][10];

}


void ProcMobs(void)
{
    Uint8 k,i;
    for (i=0; i<64; i++)
        if (mob[i][0])
        {
//pushing
            if (mob[i][8]>0)
                for (k=0; k<64; k++)
                    if (mob[k][0])
                        if (mob[k][8]>0)
                            if (k!=i)
                                if (mob[i][2]>mob[k][2]-16)
                                    if (mob[i][2]<mob[k][2]+16)
                                        if (mob[i][3]>mob[k][3]-3)
                                            if (mob[i][3]<mob[k][3]+16)

                                            {
                                                if (mob[i][2]>mob[k][2])
                                                    mob[i][6]+=100000;
                                                else
                                                    mob[i][6]-=100000;
                                            }


//gravity
            if (ffmob(mob[i][4],mob[i][5]+65536,i))
                mob[i][7]+=30000;

//x

            if (ffmob(mob[i][4]+mob[i][6],mob[i][5],i))
                mob[i][4]+=mob[i][6];
            else if (zabs(mob[i][6])>10000)
                if (ffmob(mob[i][4]+65536*zsign(mob[i][6]),mob[i][5]-65536,i))
                {   mob[i][4]+=65536*zsign(mob[i][6]);
                    mob[i][5]-=65536;
                }
                else
                    mob[i][6]=mob[i][6]/2;
//flip x
            /*
            if (mob[i][6]>10000) mob[i][10]=0;
            else
            if (mob[i][6]<-10000) mob[i][10]=1;
            */

//y
            if (ffmob(mob[i][4],mob[i][5]+mob[i][7],i))
                mob[i][5]+=mob[i][7];
            else
                mob[i][7]=-mob[i][7]/8;




            mob[i][6]=mob[i][6]/2;
            mob[i][7]=mob[i][7]*5/6;

//ai
            if (i>0)
                if (mob[i][8]>0)
                    if (mob[i][15]==0)
                        if (mob[i][13]==0)
                            ProcAi(i);

//animation
            Uint8 sp=mob[i][11];

            if (mob[i][8]<1)
            {
                if (mob[i][8]>-30) mob[i][8]--;
                else if (mob[i][14]%2==1)
                    if (endlevel[level]==1)
                        levelend=1;

                sp+=12-mob[i][8]/8;
            }
            else if (mob[i][15]>0)
            {
                sp+=12;
                mob[i][15]--;
            }
            else if (mob[i][13]>0)
            {
                sp+=8+(3-mob[i][13]/4);
                mob[i][13]--;
                if (mob[i][13]==0) MobBite(i);
            }
            else
            {
                sp+=(count/4)% 4;
                if ((zabs(mob[i][6])>10000)|(zabs(mob[i][7])>80000))
                {   //walk
                    if (i==0)
                    {
                        if (jumpstate==0)
                        {
                            if (count%16==4) PlaySound(0,0);
                            else if (count%16==12) PlaySound(1,0);
                        }
                    }
                    sp+=4;
                }
            }
//drawxy
            mob[i][2]=mob[i][4]/65536;
            mob[i][3]=1+mob[i][5]/65536;

            mob[i][1]=sp;
        }
}

void ProcPlayer(void)
{
    cameratx=-160+mob[0][2]+40-80*mob[0][10];

    if (playerstate!=1)
    {
        if (bullets0)playerstate=2;
        if (bullets1)playerstate=3;

        if ((bullets0==0)&(bullets1==0))
            playerstate=0;

        mob[0][11]=playerstate*16;
    }

    if (mob[0][13]==0)
        if (vbutton[2])
        {
            if (playerstate==0)
            {
                if (vbutton[2]==1)
                {   mob[0][13]=16;
                    PlaySound(6,0);
                }
            }
            else
            {
                if (playerstate==2)
                    if (vbutton[2]==1)
                    {   MobShoot(0);
                        bullets0--;
                        if (random8()==0)
                        {
                            levelspecial=1;
                            screenid=6;
                            screentime=5;
                        }

                    }
                if (playerstate==3)
                    if (count % 5==0) {
                        MobShoot(0);
                        bullets1--;
                    }

            }

        }
        else
        {
            if (dpad==2)
            {
                mob[0][10]=0;
                mob[0][6]+=160000;
            }
            else if (dpad==6)
            {
                mob[0][10]=1;
                mob[0][6]-=160000;
            }
            if (dpad==0)
                if (playerstate==1)
                    if (ffmob(mob[0][4],mob[0][5]-6*65536,0))
                    {
                        playerstate=0;
                        mob[0][11]=0;
                        mob[0][12]=14;

                    }
            if (dpad==4)
                if (playerstate!=1)
                {
                    playerstate=1;
                    mob[0][11]=16;
                    mob[0][12]=8;
                }

            if (ffmob(mob[0][4],mob[0][5]+65536,0)==0)
            {
                if (jumpstate) PlaySound(0,0);
                jumpstate=0;
            }
            else if (jumpstate==0) jumpstate=2;
            if (playerstate!=1)
                if (vbutton[1]==1)
                    if (jumpstate<2)
                    {
                        PlaySound(2,0);
                        jumpstate++;
                        if (random8()==0)
                        {
                            levelspecial=1;
                            screenid=13;
                            screentime=9;
                        }

                        mob[0][7]-=600000;
                        mob[0][6]=mob[0][6]*2;
                    }
        }

}
65536,0)==0)
            {
                if (jumpstate) PlaySound(0,0);
                jumpstate=0;
            }
            else if (jumpstate==0) jumpstate=2;
            if (playerstate!=1)
                if (vbutton[1]==1)
                    if (jumpstate<2)
                    {
                        PlaySound(2,0);
                        jumpstate++;
                        if (random8()==0)
                        {
                            levelspecial=1;
                            screenid=13;
                            screentime=9;
                        }

                        mob[0][7]-=600000;
                        mob[0][6
