/*
 This file is part of Adamant Armor Affection.

    Adamant Armor Affection is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Adamant Armor Affection is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Adamant Armor Affection.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "vars.h"
#include "sblit.h"
#include "ssystem.h"

#include "mainmenu.h"
#include "gameproc.h"

//next mode , triggermode, changemodeeffect, musictrack, screen

Uint8 GameStateData[24][5]=
{
//next   trig   eff mus img
    {   1,   105,     0,128,  10},//logo0 screen
    {   2,   130,     0,128,  1},//logo1 screen
    {   3,    20,     0,  0,  0},//logo2 screen (a game by quasist)
    {   4,    50,     1,  0,  11},//Title Splash

    {   8,   180,     0,  0,  9},//Title
    {   6,    10,     0,  4,  24},//GameOver1
    {   7,   180,     0,  4,  23},//GameOver2
    {  16,     0,     0,128,  24},//GameOver3

    {   2,   255,     2,  1,  2},//Main Menu
    {  16,   105,     0,128, 11},//New Game
    {   8,     0,     5,128,128},//Load Game
    {   4,   255,     3,  2,128},//Briefing

    {  16,   104,     0,  9,  7},//Tutorial
    {   8,     0,     4,  5,  3},//Options
    {  15,     0,     6,  3, 12},//Exit
    { 128,     0,     0,  7, 10}, //Post Screen

    {   5,   255,    10,  9,128},//GamePlay
    {  16,   0,    0, 8, 17},//Mission1
    {  16,   0,    0, 8,18},//Mission2
    {  16,   0,    0, 8,19},//Mission3

    {  16,   0,    0, 8,20},//Mission4
    {  16,   0,   0, 8,21},//Mission5
    {  14,   0,    0, 8,22},//Mission6
    {   0,   255,    11,  6,128} //levelend
};

void ShowLevelEnd(void)
{
    levelend=0;
    mob[0][2]=100;
    mob[0][4]=100000;
    levelloaded=128;
    if ((buttonpressed==1)|(level==6))
    {
        EndGameState=1;
        NextGameState=16+level;
        switch (level)
        {
        case 0:
            NextGameState=8;
            break;
        }


        level++;
    }
    else
        DrawScreen(8);

}

void SetGameState(Uint8 index)
{
    if (index==128)
        GameLoopEnabled=0;
    else
    {
        GameStateCount=0;
        GameState=index;
        NextGameState=GameStateData[GameState][0];
        if (GameStateData[GameState][3]!=MusicPlaying)
            PlayMusic(GameStateData[GameState][3]);
    }
}
void ProcGameState(void)
{
    ClrScr();

//Visualizing the GameState
    if (GameStateData[GameState][4]<128)
        DrawScreen(GameStateData[GameState][4]);

    switch (GameStateData[GameState][2])//special states
    {
    case 1: //title
        ProcTitle();
        break;
    case 2: //main menu
        ProcMainMenu();
        break;
    case 3: //main menu
        ProcBriefing();
        break;
    case 5:// Load Game
        DrawText(40,80,15,"SD CARD ERROR   ");
        break;
    case 4:// Options
        if (count/3 %2)
        {
            DrawText(40,60,14,"UNREGISTRATED   ");
            DrawText(40,80,14,"         USER   ");
        }
        break;
    case 6:
        ProcCredits();
        break;
    case 10: //GAME PLAY
        ProcGame();
        break;
    case 11: //levelend
        ShowLevelEnd();
        break;
    }
//Triggers
    if (GameStateData[GameState][1]==0)//anykey
    {
        if (buttonpressed==1) EndGameState=1;
    }
    else if (GameStateData[GameState][1]<100) //Wait!
    {
        if (GameStateCount>GameStateData[GameState][1]*5)
            EndGameState=1;

    }
    else if (GameStateData[GameState][1]<200) //wait or anykey
    {
        if ((GameStateCount>(GameStateData[GameState][1]-100)*5)
                |(buttonpressed==1))
            EndGameState=1;


    }
    if (EndGameState)
    {
        EndGameState--;
        if (EndGameState==0)
            SetGameState(NextGameState);
    }


    GameStateCount++;



}

    case 11: //levelend
        ShowLevelEnd();
        break;
    }
//Triggers
    if (GameStateData[GameState][1]==0)//anykey
    {
        if (buttonpressed==1) EndGameState=1;
    }
    else if (GameStateData[GameState][1]<100) //Wait!
    {
        if (GameStateCount>GameStateData[GameState][1]*5)
            EndGameState=1;

    }
    else if (GameStateData[GameState][1]<200) //wait or anykey
    {
        if ((GameStateCount>(GameStateDat
