/*
 * Copyright (C) 2009 Christopho, Solarus - http://www.solarus-engine.org
 * 
 * Solarus is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Solarus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include "Common.h"
#include "lowlevel/Rectangle.h"

/**
 * @brief Provides functions to make mathematic computations.
 */
class Geometry {

  public:

    // Mathematic constants:
    // we don't use the ones from cmath
    // because they are not ANSI
    static const float PI;
    static const float TWO_PI;
    static const float PI_OVER_2;
    static const float THREE_PI_OVER_2;
    static const float SQRT_2;

    static const int radians_to_degrees(float radians);
    static const float degrees_to_radians(float degrees);

    static float get_distance(int x1, int y1, int x2, int y2);
    static float get_angle(int x1, int y1, int x2, int y2);
    static const Rectangle get_xy(float angle, int distance);
    static const Rectangle get_xy(const Rectangle &xy1, float angle, int distance);
};

