/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j.addon;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import java.util.Stack;
import org.ini4j.IniHandler;
import org.ini4j.IniParser;
import org.ini4j.InvalidIniFormatException;

public class FancyIniParser
extends IniParser {
    public static final char INCLUDE_BEGIN = '<';
    public static final char INCLUDE_END = '>';
    private boolean _allowEmptyOption = true;
    private boolean _allowUnnamedSection = true;
    private boolean _allowMissingSection = true;
    private String _missingSectionName = "";
    private boolean _allowSectionCaseConversion;
    private boolean _allowOptionCaseConversion;
    private boolean _allowInclude = true;

    public synchronized void setAllowEmptyOption(boolean flag) {
        this._allowEmptyOption = flag;
    }

    public synchronized boolean isAllowEmptyOption() {
        return this._allowEmptyOption;
    }

    public synchronized void setAllowUnnamedSection(boolean flag) {
        this._allowUnnamedSection = flag;
    }

    public synchronized boolean isAllowUnnamedSection() {
        return this._allowUnnamedSection;
    }

    public synchronized void setAllowMissingSection(boolean flag) {
        this._allowMissingSection = flag;
    }

    public synchronized boolean isAllowMissingSection() {
        return this._allowMissingSection;
    }

    public synchronized void setMissingSectionName(String name) {
        this._missingSectionName = name;
    }

    public synchronized String getMissingSectionName() {
        return this._missingSectionName;
    }

    public synchronized void setAllowSectionCaseConversion(boolean flag) {
        this._allowSectionCaseConversion = flag;
    }

    public synchronized boolean isAllowSectionCaseConversion() {
        return this._allowSectionCaseConversion;
    }

    public synchronized void setAllowOptionCaseConversion(boolean flag) {
        this._allowOptionCaseConversion = flag;
    }

    public synchronized boolean isAllowOptionCaseConversion() {
        return this._allowOptionCaseConversion;
    }

    public synchronized boolean isAllowInclude() {
        return this._allowInclude;
    }

    public synchronized void setAllowInclude(boolean flag) {
        this._allowInclude = flag;
    }

    @Override
    public void parse(Reader input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(new IniSource(input), handler);
    }

    @Override
    public void parse(URL input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(new IniSource(input), handler);
    }

    protected void parse(IniSource source, IniHandler handler) throws IOException, InvalidIniFormatException {
        handler.startIni();
        String sectionName = null;
        String line = source.readLine();
        while (line != null) {
            if ((line = line.trim()).length() != 0 && ";#".indexOf(line.charAt(0)) < 0) {
                if (line.charAt(0) == '[') {
                    if (sectionName != null) {
                        handler.endSection();
                    }
                    if (line.charAt(line.length() - 1) != ']') {
                        this.parseError(line, source.getLineNumber());
                    }
                    if ((sectionName = this.unescape(line.substring(1, line.length() - 1).trim())).length() == 0 && !this.isAllowUnnamedSection()) {
                        this.parseError(line, source.getLineNumber());
                    }
                    if (this.isAllowSectionCaseConversion()) {
                        sectionName = sectionName.toLowerCase(Locale.getDefault());
                    }
                    handler.startSection(sectionName);
                } else {
                    if (sectionName == null) {
                        if (this.isAllowMissingSection()) {
                            sectionName = this.getMissingSectionName();
                            handler.startSection(sectionName);
                        } else {
                            this.parseError(line, source.getLineNumber());
                        }
                    }
                    int idx = line.indexOf(61);
                    String name = null;
                    String value = null;
                    if (idx < 0) {
                        if (this.isAllowEmptyOption()) {
                            name = line;
                        } else {
                            this.parseError(line, source.getLineNumber());
                        }
                    } else {
                        name = this.unescape(line.substring(0, idx)).trim();
                        value = this.unescape(line.substring(idx + 1)).trim();
                    }
                    if (name.length() == 0) {
                        this.parseError(line, source.getLineNumber());
                    }
                    if (this.isAllowOptionCaseConversion()) {
                        name = name.toLowerCase(Locale.getDefault());
                    }
                    handler.handleOption(name, value);
                }
            }
            line = source.readLine();
        }
        if (sectionName != null) {
            handler.endSection();
        }
        handler.endIni();
    }

    protected static class IniSource {
        protected URL base;
        protected Stack<URL> bases;
        protected LineNumberReader reader;
        protected Stack<LineNumberReader> readers;

        protected IniSource(Reader input) {
            this.reader = new LineNumberReader(input);
        }

        protected IniSource(URL base) throws IOException {
            this.base = base;
            this.reader = new LineNumberReader(new InputStreamReader(base.openStream()));
        }

        protected void include(LineNumberReader input, URL location) {
            if (this.readers == null) {
                this.readers = new Stack();
                this.bases = new Stack();
            }
            this.readers.push(this.reader);
            this.bases.push(this.base);
            this.reader = input;
            this.base = location;
        }

        protected int getLineNumber() {
            return this.reader.getLineNumber();
        }

        protected String readLine() throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                if (this.readers != null && !this.readers.empty()) {
                    this.reader = this.readers.pop();
                    this.base = this.bases.pop();
                    line = this.readLine();
                }
            } else {
                String buff = line.trim();
                if (buff.length() > 2 && buff.charAt(0) == '<' && buff.charAt(buff.length() - 1) == '>') {
                    buff = buff.substring(1, buff.length() - 1).trim();
                    URL loc = this.base == null ? new URL(buff) : new URL(this.base, buff);
                    LineNumberReader inc = new LineNumberReader(new InputStreamReader(loc.openStream()));
                    this.include(inc, loc);
                    line = this.readLine();
                }
            }
            return line;
        }
    }
}

