/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.ini4j.Convert;
import org.ini4j.IniHandler;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.ServiceFinder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IniParser {
    public static final String COMMENTS = ";#";
    public static final char OPERATOR = '=';
    public static final char SECTION_BEGIN = '[';
    public static final char SECTION_END = ']';
    public static final String SERVICE_ID = "org.ini4j.IniParser";
    public static final String DEFAULT_SERVICE = "org.ini4j.IniParser";

    public static IniParser newInstance() {
        return (IniParser)ServiceFinder.findService("org.ini4j.IniParser", "org.ini4j.IniParser");
    }

    public void parse(InputStream input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(new InputStreamReader(input), handler);
    }

    public void parse(Reader input, IniHandler handler) throws IOException, InvalidIniFormatException {
        LineNumberReader reader = new LineNumberReader(input);
        handler.startIni();
        String sectionName = null;
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() != 0 && COMMENTS.indexOf(line.charAt(0)) < 0) {
                if (line.charAt(0) == '[') {
                    if (sectionName != null) {
                        handler.endSection();
                    }
                    if (line.charAt(line.length() - 1) != ']') {
                        this.parseError(line, reader.getLineNumber());
                    }
                    if ((sectionName = this.unescape(line.substring(1, line.length() - 1).trim())).length() == 0) {
                        this.parseError(line, reader.getLineNumber());
                    }
                    handler.startSection(sectionName);
                } else {
                    int idx;
                    if (sectionName == null) {
                        this.parseError(line, reader.getLineNumber());
                    }
                    if ((idx = line.indexOf(61)) <= 0) {
                        this.parseError(line, reader.getLineNumber());
                    }
                    String name = this.unescape(line.substring(0, idx)).trim();
                    String value = this.unescape(line.substring(idx + 1)).trim();
                    if (name.length() == 0) {
                        this.parseError(line, reader.getLineNumber());
                    }
                    handler.handleOption(name, value);
                }
            }
            line = reader.readLine();
        }
        if (sectionName != null) {
            handler.endSection();
        }
        handler.endIni();
    }

    public void parse(URL input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parse(input.openStream(), handler);
    }

    public void parseXML(InputStream input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parseXML(new InputStreamReader(input), handler);
    }

    public void parseXML(Reader input, final IniHandler handler) throws IOException, InvalidIniFormatException {
        class XML2Ini
        extends DefaultHandler {
            static final String TAG_SECTION = "section";
            static final String TAG_OPTION = "option";
            static final String TAG_INI = "ini";
            static final String ATTR_KEY = "key";
            static final String ATTR_VALUE = "value";
            static final String ATTR_VERSION = "version";
            static final String CURRENT_VERSION = "1.0";

            XML2Ini() {
            }

            @Override
            public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
                String key = attrs.getValue(ATTR_KEY);
                if (qname.equals(TAG_INI)) {
                    String ver = attrs.getValue(ATTR_VERSION);
                    if (ver == null || !ver.equals(CURRENT_VERSION)) {
                        throw new SAXException("Missing or invalid 'version' attribute");
                    }
                } else {
                    if (key == null) {
                        throw new SAXException("missing 'key' attribute");
                    }
                    if (qname.equals(TAG_SECTION)) {
                        handler.startSection(key);
                    } else if (qname.equals(TAG_OPTION)) {
                        handler.handleOption(key, attrs.getValue(ATTR_VALUE));
                    } else {
                        throw new SAXException("Invalid element: " + qname);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qname) throws SAXException {
                if (qname.equals(TAG_SECTION)) {
                    handler.endSection();
                }
            }
        }
        XML2Ini xml2ini = new XML2Ini();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(input), (DefaultHandler)xml2ini);
        }
        catch (Exception x) {
            throw new InvalidIniFormatException(x);
        }
    }

    public void parseXML(URL input, IniHandler handler) throws IOException, InvalidIniFormatException {
        this.parseXML(input.openStream(), handler);
    }

    protected String unescape(String line) {
        return Convert.unescape(line);
    }

    protected void parseError(String line, int lineNumber) throws InvalidIniFormatException {
        throw new InvalidIniFormatException("parse error (at line: " + lineNumber + "): " + line);
    }
}

