/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#include <string>
#include "fex/fex.h"
using namespace std;

int is_ext(const char *s, const char *ext);
int is_playlist(const char *s);
int compare(const void* a, const void* b);
int read_file(char *s, const char *fname, int fsize);
int read_zip(char *s, const char *fname, int fsize, int index);
int plugin_filter_cb(void *data, const char *name);
int plugin_filter_zip_cb(void *data, const char *name);
int filter_opl_cb(void *data, const char *name);
int parse_id3v1(char* fname, string* fieldname, string* fielddata, int max);
int is_fex(const char *s);

void error( fex_err_t err );

