#ifndef _UADE_FRONTEND_CONFIG_H_
#define _UADE_FRONTEND_CONFIG_H_

#include <include/amigafilter.h>

/* EAGLEPLAYER OPTIONS */
#define EP_A500              (1 << 0)
#define EP_A1200             (1 << 1)
#define EP_ALWAYS_ENDS       (1 << 2)
#define EP_CONTENT_DETECTION (1 << 3)
#define EP_SPEED_HACK        (1 << 4)

#define ES_A500              (1 <<  5)
#define ES_A1200             (1 <<  6)
#define ES_BROKEN_SUBSONGS   (1 <<  7)
#define ES_LED_OFF           (1 <<  8)
#define ES_LED_ON            (1 <<  9)
#define ES_NO_HEADPHONES     (1 <<  10)
#define ES_NO_PANNING        (1 <<  11)
#define ES_NO_POSTPROCESSING (1 <<  12)
#define ES_NTSC              (1 <<  13)
#define ES_SPEED_HACK        (1 <<  14)
#define ES_VBLANK            (1 <<  15)
#define ES_IGNORE_PLAYER_CHECK (1 <<  16)
#define ES_BROKEN_SONG_END   (1 <<  17)
#define ES_NAME_DETECTION    (1 <<  18)

struct uade_ep_options {
	char o[256];
	size_t s;
};

struct uade_config {
  int action_keys;
  int always_ends;
  int filter_type;
  int led_forced;
  int led_state;
  int gain_enable;
  float gain; /* should be removed of uade_effect integrated */
  int headphones;
  int ignore_player_check;
  char *interpolator;
  int no_filter;
  int no_song_end;
  int one_subsong;
  int panning_enable;
  float panning; /* should be removed */
  int random_play;
  int recursive_mode;
  int silence_timeout;
  int speed_hack;
  int subsong_timeout;
  int timeout;
  int timeout_forced;
};

void uade_add_ep_option(struct uade_ep_options *opts, const char *s);
void uade_config_set_defaults(struct uade_config *uc);
int uade_get_filter_type(const char *value);
int uade_get_silence_timeout(const char *value);
int uade_get_subsong_timeout(const char *value);
int uade_get_timeout(const char *value);
float64 uade_convert_to_double(const char *value,
			      float64 def,
			      float64 low, float64 high, const char *type);
int uade_load_config(struct uade_config *uc, const char *filename);

#endif
