/*  
    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
extern "C" 
{
#include "sexypsf/driver.h"
#include "sexypsf/PsxCounters.h"
#include "sexypsf/R3000A.h"
void execI(void);
}

#include "../plugin.h"
#include "../util.h"

static struct sound_plugin plugin;
static int playing;
static string fieldname[5];
static string fielddata[5];
static unsigned char* tmpbuf;
static int writepos_bytes;
static int readpos_bytes;
static PSFINFO *pi;

static int init_file(char *fname)
{
    playing = 0;
    if (!(pi=sexy_load(fname)))
    {
        fprintf(stderr,"sexypsfplugin:init_file - Error loading PSF");
        return -1;
    }
    int x = 0;
    if (pi->game)
    {
        fieldname[x] = "Game";
        fielddata[x++] = pi->game;
    }
    if (pi->title)
    {
        fieldname[x] = "Title";
        fielddata[x++] = pi->title;
    }
    if (pi->artist)
    {
        fieldname[x] = "Artist";
        fielddata[x++] = pi->artist;
    }
    if (pi->genre)
    {
        fieldname[x] = "Genre";
        fielddata[x++] = pi->genre;
    }
    
    plugin.fieldname = fieldname;
    plugin.fielddata = fielddata;
    plugin.nfields = x;
    printf("X = %d, fielddata[0] = %s\n",x,fielddata[0].c_str());

    tmpbuf = (unsigned char*)malloc(4096); 
    // Just big enough, not sure what is.. 

    plugin.length = pi->length;
    writepos_bytes = -1;
    readpos_bytes = 0;
    playing = 1;
    return 0;
}

static int close()
{
    for(int i = 0; i < 5; i++)
    {
        fieldname[i].clear();
        fielddata[i].clear();
    }
    if (tmpbuf)
    {
        free(tmpbuf);
        tmpbuf = NULL;
    }
    psxShutdown(); // Should i check? naaah
    sexy_freepsfinfo(pi);
    playing = plugin.length = plugin.nfields = 0;
    return 0;
}

void sexyd_update(unsigned char* buf, long len)
{
    //printf("len '= %d\n",len);
    memcpy(tmpbuf, buf, len);
    writepos_bytes = len;
    readpos_bytes = 0;
}

static int fill_buffer(signed short *dest, int len)
{
    //printf("Hejsan\n");
    if(playing)
    {
        int written_bytes = 0;
        while (written_bytes < len)
        {
            //printf("loop! %d, %d\n",written_bytes, len);
            if (writepos_bytes - readpos_bytes > 0)
            {
                int tmplen = writepos_bytes - readpos_bytes;
                if (len < tmplen)
                    tmplen = len;
                //printf("grabbing %d\n",tmplen);
                memcpy(dest, tmpbuf, tmplen);
                written_bytes += len;
                readpos_bytes += len;
            }
            else
            {
                int x = CounterSPURun();
                /*if (!x)
                {
                    printf("CounterSPURun ended\n");
                    playing = 0;
                    break;
                }*/
                execI();
                SPUendflush();
                /*if (writepos_bytes == 0)
                {
                    printf("nothing written\n");
                    playing = 0;
                    break;
                }*/
            }
        }

        //printf("written_bytes = %d\n",written_bytes);
        //FILE *fp; 
        //fp = fopen("out","a");
        //fwrite((const void*)dest, written_bytes, 1, fp);
        //fclose(fp);
        return written_bytes;
    }
    return 0;
}

static int can_handle(const char *name)
{
    return (is_ext(name, ".psf") || is_ext(name, ".minipsf"));
}

extern "C" {

#ifndef INIT_SOUND_PLUGIN
#define INIT_SOUND_PLUGIN sexypsf_init_sound_plugin
#endif

struct sound_plugin *INIT_SOUND_PLUGIN()
{
    memset(&plugin, 0, sizeof(plugin));
    plugin.plugname = "sexypsf";
    plugin.init_file        = init_file;
    //plugin.init_data      = init_data;
    //plugin.request_format = NULL;
    //plugin.set_position   = set_position;
    plugin.fill_buffer      = fill_buffer;
    plugin.can_handle       = can_handle;
    plugin.close            = close;
    plugin.channels   = 2;
    plugin.freq       = 22050;
    plugin.replaygain = 1;
    plugin.tune       = 0;
    plugin.subtunes   = 1;
    plugin.clockfreq  = 275; 
    return &plugin;
}

}

