
#undef XY
#undef SCREENBASE
#undef SCREEN_SET
#undef SCREEN_COPY
#undef LINEAR_X

#if (SCREEN_ROTATION == 0)

// NORMAL (FROM TOP-LEFT)
#define XY(x,y) ((y)*SCREEN_WIDTH+(x))
#define SCREENBASE ((Pixel*)SCREEN_PTR)
#define SCREEN_SET screen_set_tl
#define SCREEN_COPY screen_copy_tl

#define LINEAR_X

#elif (SCREEN_ROTATION == 1)

// FROM TOP-RIGHT
#define XY(x,y) ((x) * SCREEN_WIDTH - (y))
#define SCREENBASE (((Pixel*)SCREEN_PTR)+SCREEN_WIDTH-1-OFFSET)
#define SCREEN_SET screen_set_tr
#define SCREEN_COPY screen_copy_tr

#elif (SCREEN_ROTATION == 2)

// FROM BOTTOM-RIGHT
#define XY(x,y) (-(y)*SCREEN_WIDTH-(x))
#define SCREENBASE (((Pixel*)SCREEN_PTR)+SCREEN_WIDTH*SCREEN_HEIGHT-1-OFFSET)
#define SCREEN_SET screen_set_br
#define SCREEN_COPY screen_copy_br

#elif (SCREEN_ROTATION == 3)

// FROM BOTTOM-LEFT
#define XY(x,y) ((y) - (x) * SCREEN_WIDTH)
#define SCREENBASE (((Pixel*)SCREEN_PTR)+SCREEN_WIDTH*(SCREEN_HEIGHT-1))
#define SCREEN_SET screen_set_bl
#define SCREEN_COPY screen_copy_bl

#else

#error "SCREEN_ROTATION not defined!"

#endif

void SCREEN_COPY(int x, int y, uchar *src, int width, int height, int sw, int solid)
{
	int w;

	Pixel *dst = SCREENBASE + XY(x,y);

	int smod = (sw - width);
	int dmod = XY(-width, 1);

	while(height--)
	{
		w = width;
		if(solid)
		{
			while(w--)
#ifdef LINEAR_X
			COPY_PIXEL(dst++, src++);
#else
			{
				COPY_PIXEL(dst, src++);
				dst += XY(1,0);
			}
#endif
		}
		else
		{
			while(w--)
			{
				if(*src)//;// < *dst)
					COPY_PIXEL(dst, src);
					//*dst = colors[*src];
#ifdef LINEAR_X
				dst++;
#else
				dst += XY(1,0);
#endif
				src++;
			}
		}
		dst += dmod;
		src += smod;
	}
}


void SCREEN_SET(int x, int y, int width, int height, int col)
{
	int w;
	
#ifdef DIRECT
	Pixel color = col;
#else
	Pixel color = colors[col];
#endif
	
	Pixel *dst = SCREENBASE + XY(x,y);
	
	int dmod = XY(-width, 1);

	while(height--)
	{
		w = width;
		while(w--)
#ifdef LINEAR_X
			*dst++ = color;
#else
			{
				*dst = color;
				dst += XY(1,0);
			}
#endif
		dst += dmod;
	}
}
