
#include "pogo/stdcore.h"
#include "pogo/font.h"
#include "pogo/fixedfont.h"
#include "pogo/screen.h"
#include "pogo/device.h"


//int screen_setcolors(unsigned int *pal, int start, int size);
//void screen_copy(int x, int y, uchar *src, int width, int height, int sw, int solid);
//void screen_set(int x, int y, int width, int height, int color);
//extern int g_screenWidth;
//extern int g_screenHeight;
//extern void *g_screenPtr;


//enum {BG, FG};
//
#define BG 0x00

//uint32 colors[2];

//static uint32 colors[2];
//static uint32 oldbg = -1;
//static uint32 oldfg = -1 ;
//static uint32 oldcolflag;

//void font_setcolor(uint32 fg, uint32 bg)
//{
	//colors[0] = bg;
	//colors[1] = fg;
//}

//void set_screencolors(Font *font)
void font_setcolor(uint32 fg, uint32 bg)
{
	int i;
	uint32 color;
	
	
	int red = (bg & 0xff0000);
	int green = (bg & 0x00ff00)<<8;
	int blue = (bg & 0xff)<<16;

	int ra = ( (fg & 0xff0000) - red)>>8;
	int ga = ( ((fg & 0xff00)<<8) - green)>>8;
	int ba = ( ((fg & 0xff)<<16) - blue)>>8;

	for(i=0; i<256; i++)
	{
		//int k = (255-i);
		color = (red&0xff0000) | ((green>>8)&0xff00) | ((blue>>16)&0xff);

		red += ra;
		green += ga;
		blue += ba;

		screen_setcolors(&color, i, 1);
	}
}

int find_index(Font *font, int c)
{
	register int index;
	if(font->flags & FFLG_UNICODE)
	{
		int *seq = font->sequences;
		index = 0;
	
		for(; *seq >= 0; seq += 2)
		{
			if((c >= seq[0]) && (c <= seq[1]))
			{
				index += (c - seq[0]);
				break;
			}
			index += (seq[1] - seq[0] + 1);				
		}
	
		if(*seq < 0)			
			return 0;
	}
	else
	{
		if(c < font->first || c >= font->last)
			return 0;
		index = c - font->first;
	}
	
	return index;
}


static uchar font_putmono(Font *font, int c, int x, int y)
{
	register int w, index;
	int solid = !(font->flags & FFLG_TRANSP);
	//if(c < font->first || c >= font->last)
	//	return 0;

	w = font->charwidth;
	if(y >= 0)
	{
		if(c == ' ')
		{
			if(solid)
				screen_set(x, y, w, font->height, BG);
		}
		else
		{
			index = find_index(font, c);
			
			if(solid)
				screen_copy(x, y, &font->pixels[index * w], w, font->height, font->width, 1);
			else
				screen_copy(x, y, &font->pixels[index * w], w, font->height, font->width, 0);
		}
	}
	
	//w += font->spacing;
	if(w <= 0) w = 1;
		
	return w;
}

static uchar font_putprop(Font *font, int c, int x, int y)
{
	register int offset, w, index;
	//register int ff = font->first;
	int solid = !(font->flags & FFLG_TRANSP);
	
	x += (font->spacing/3);

	if(c == ' ')
	{
		w = font->charwidth;
		if((y >= 0) && solid)
			screen_set(x, y, w, font->height, BG);
	} 
	else
	{
		index = find_index(font, c);
		offset =  font->offsets[index];
		w = font->offsets[index + 1] - offset;
		if(y >= 0)
		{

			if(solid)
				screen_copy(x, y, &font->pixels[offset], w, font->height, font->width, 1);
			else
				screen_copy(x, y, &font->pixels[offset], w, font->height, font->width, 0);
		}
	}

	w += font->spacing;
	if(w <= 0) w = 1;

	return w;
}

static uchar putchar_internal(Font *font, int c, int x, int y)
{
	int rc, fl;

	//if(font->flags & FFLG_COLOR)
	//	colors = font->colors;
	//else
	//	colors = font_colors;
	
	if(font->offsets)
	{
		if(font->flags & FFLG_BOLD)
		{
			font_putprop(font, c, x, y);
			fl = font->flags;
			font->flags |= FFLG_TRANSP;
			rc = font_putprop(font, c, x+1, y);
			font->flags = fl;
			return rc+1;
		}
		else
			return font_putprop(font, c, x, y);
	}
	else
	{
		if(font->flags & FFLG_BOLD)
		{
			font_putmono(font, c, x, y);
			fl = font->flags;
			font->flags |= FFLG_TRANSP;
			rc = font_putmono(font, c, x+1, y);
			font->flags = fl;
			return rc+1;
		}
		else
			return font_putmono(font, c, x, y);
	}
}

uchar font_putchar(Font *font, int c, int x, int y)
{
	//set_screencolors(font);
	return putchar_internal(font, c, x,  y);
}


int font_text(Font *font, char *str, int x, int y)
{
	int l = 0;

	//set_screencolors(font);
	while(*str)
		l += font_putchar(font, *str++, x+l, y);
	return l;
}

int font_text_multi(Font **fontlist, int *current, char *txt, int x, int y)
{
	Font *font;
	int l = 0;
	int c;
	unsigned char *str = (unsigned char *)txt;

	font = fontlist[*current];

	while(*str)
	{
		c = *str++;
		if(c <= 8)
			font = fontlist[*current = (c - 1)];
		else
		if(c <= 0x7F)
			l += font_putchar(font, c, x+l, y);
		else
		{
			int mask = 0x20;
			int i = 1;
			// UTF-8
			while(mask & c)
			{
				mask = mask>>1;
				i++;
			}
			//printf("unicode %x has %d chars\n", c, i);
			
			c &= (0x3F>>i);
			// l = 1-5
			while(i--)
			{
				c = c << 6;
				c |= ((*str++)&0x3F);
			}
			//printf("unicode %x has %d chars\n", c, i);

			l += font_putchar(font, c, x+l, y);
		}			
	}

	return l;
}

Font *font_dup(Font *font)
{
	Font *f = (Font*)malloc(sizeof(Font));
	memcpy(f, font, sizeof(Font));
	return f;
}

static char *filename(char *name)
{
	char *end = &name[strlen(name)-1];

	while(end > name)
	{
		if(*end == '/')
			return end+1;
		end--;
	}

	return name;

	//if((p = strrchr(name, '/')))
	//	return p+1;
	//else
	//	return name;
}

/*

!FFLG_COLOR = Pixels are 0 or 1
FFLG_COLOR, no palette = Pixels are intensity 0 to 255
with palette = use it

*/

#define GET32(t) (t[0] | (t[1]<<8) | (t[2]<<16) | (t[3] <<24))
#define GET16(t) (t[0] | (t[1]<<8))

Font *font_memload(uchar *mem, char *name)
{
	int ocount;
	int size, pix_size, l, i;
	Font font;
	Font *rfont;

	memcpy(&font, mem, 6);
	font.width = (mem[7]<<8) | mem[6];
	

	pix_size = font.width * font.height;
	if(pix_size & 1) pix_size++;

	l = (int)strlen(name);
	if(!(l & 1))
		l++;

	size = sizeof(Font) + l + 1;

	rfont = (Font *)malloc(size);
	memcpy(rfont, &font, 8);

	//fprintf(stderr, "FONT %p width %d\n", rfont, font.width);

	rfont->name = (char *)&rfont[1];
	strcpy(rfont->name, name);

	mem += 8;

	if(rfont->flags & FFLG_COLOR)
	{
		rfont->colors = (uint16 *)&mem[2];
		l = *((uint16*)mem);
		//printf("%d colors in font\n", l);
		mem += (l*2+4);
		if(!l)
			rfont->colors = NULL;
	}
	else
		rfont->colors = NULL;
	
#ifdef GBA
	rfont->pixels = mem;	
#else
	rfont->pixels = malloc(pix_size);
	memcpy(rfont->pixels, mem, pix_size);
#endif
	mem += pix_size;
	
	if(rfont->flags & FFLG_UNICODE)
	{
		int start, end;
		int count = 0;
		uchar *s = mem;
		while(GET32(s) >= 0) { s+=4; count++; }

		//fprintf(stderr, "%d sequences at %x\n", count, mem);
		
		//ASSERT((count & 1) == 0);
		
		rfont->sequences = (int *)malloc(count * 4 + 8);
		
		ocount = 0;
		
		for(i=0; i<count/2; i++)
		{
			start = GET32(mem);
			mem += 4;
			end = GET32(mem);
			mem += 4;
			rfont->sequences[i*2] = start;
			rfont->sequences[i*2+1] = end;
			ocount += (end - start + 1);
			//fprintf(stderr, "%x-%x\n", start, end);
		}
		rfont->sequences[i*2] = -1;
		rfont->sequences[i*2+1] = -1;
		//memcpy(rfont->sequences, mem, (int)((uchar*)s - mem + 8) );
		
		mem = (uchar *)(s+8);
	}
	else
		ocount = rfont->last - rfont->first + 1;
	
	//fprintf(stderr, "%d offsets at %x\n", ocount, mem);
	if(rfont->flags & FFLG_PROPORTIONAL)
	{
		rfont->offsets = (uint16 *)malloc(ocount * 2);
		for(i=0; i<ocount; i++, mem+=2)
		{
			rfont->offsets[i] = GET16(mem);
			//fprintf(stderr, "%x\n", rfont->offsets[i]);
		}
		//rfont->offsets = (uint16 *)mem;
		//fprintf(stderr, "%d %d %d %d\n", rfont->offsets[0], rfont->offsets[1], rfont->offsets[2], rfont->offsets[3]);
	}
	else
		rfont->offsets = NULL;

	return rfont;
}

/*
static int fsize(FILE *fp)
{
	int rc;
	int pos = ftell(fp);
	fseek(fp, 0, SEEK_END);
	rc = ftell(fp);
	fseek(fp, pos, SEEK_SET);
	return rc;
}
*/

void font_free(Font *font)
{
	if(font->sequences)
		free(font->sequences);
	if(font->offsets)
		free(font->offsets);
#ifndef GBA
	if(font->pixels)
		free(font->pixels);
#endif
	
	free(font);
}

Font *font_load(char *name)
{
	int fd;
	uchar *mem = NULL;
	Font *font = NULL;

	//fprintf(stderr, "font %s\n", name);
	
	fd = pogo_open(name, O_RDONLY);
	if(fd >= 0)
	{		
#ifdef GBA		
		mem =(uchar *) lseek(fd, 0, SEEK_MEM);
#endif
		//fprintf(stderr, "at %p\n", mem);
		if(!mem)
		{
			int len = pogo_lseek(fd, 0, SEEK_END);
			pogo_lseek(fd, 0, SEEK_SET);
			
			mem = (uchar *)malloc(len);
			
			//dprintf("Reading font size %d to %p\n", len, mem);
			
			pogo_read(fd, mem, len);
			font = font_memload(mem, filename(name));
			free(mem);		
		}
		else
			font = font_memload(mem, filename(name));

		pogo_close(fd);		
	}
	
	//fprintf(stderr, "FONT: %p\n", font);
	
	return font;
}

void font_settarget(void *dest, int width, int height, int flow)
{
	screen_set_target(dest, width, height, flow);
	//g_screenPtr = dest;
	//g_screenWidth = width;
	//g_screenHeight = height;
}

//#ifdef LIBPOGO
//extern uint32 pogo_fixed_font;
//#endif

static Font *fixed = NULL;

Font *font_getdefault()
{
	if(!fixed)
		fixed = font_memload((uchar*)pogo_fixed_font, "fixed");

	return fixed;
}
