/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef PLUGIN_H
#define PLUGIN_H

#include <string>
using namespace std;

struct sound_plugin
{
    const char *plugname;

    int (*init_data)(char *name, void *data, int size);
    int (*init_file)(char *filename);
    int (*request_format)(int freq, int chn);
    int (*set_position)(int msecs, int subtune);
    int (*fill_buffer)(signed short *dest, int len);
    int (*can_handle)(const char *name);
    int (*close)();

    int freq;
    int channels;
    int length;
    int subtunes;
    int tune;
    int clockfreq;
    double replaygain; // neutral <= 1, multiplied > 1 // TODO

    // Data on current song
    string *fieldname;
    string *fielddata;
    int nfields;
};

#endif

