/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <SDL/SDL.h>
#include "SDLScreen.h"
#include "Input.h"
#include "PlayerApp.h"
#include "State.h"

#if defined(GP2X) || defined(A320)
#include <sys/times.h>
void hw_set_screen(bool on);
void hw_init();
void hw_set_cpu(int speed);
int  hw_get_voltage();
#endif

//#include <sys/sysmips.h>

PlayerApp *app;
extern BrowserState g_browserState;
extern PlayListState g_playlistState;
extern SaveState g_saveState;
bool aopen = false;
int current_clockfreq = -1;
static int bcount = 0;

extern "C"
{
	void busy(int x)
	{
		bcount = 0;
		if(x)
			bcount = (bcount+1) % 6;
		app->lcd->SetLed(LedControl::BUSY, bcount);
		app->lcd->Render();
	}
}

int main(int argc, char **argv)
{
#if defined(GP2X) || defined(A320)
	struct tms buf;
	clock_t startt = times(&buf);
	fprintf(stderr, "main - Start %d\n", startt);
	hw_init();
#endif

//    sysmips(MIPS_FIXADE, 0,0,0);

	app = new PlayerApp(argc > 1 ? argv[1] : NULL);
	app->Layout();

    system("free");
	fprintf(stderr, "main - First Layout\n");

	g_screen.Update();

	Input *input = new Input();

	IState *currentState = &g_browserState;
	currentState->Enter();

	app->lcd->SetLed(LedControl::VOLT, 12);

#if defined(GP2X) || defined(A320)
	int display_on = 1;
	int count      = 0;
	int volt       = hw_get_voltage();
	if(app->cpu_scaling)
	{
#ifdef A320
	fprintf(stderr, "main - Clockfreq to 228\n");
		current_clockfreq = 228;
		hw_set_cpu(228);
#else
        fprintf(stderr, "main - Clockfreq to 100\n");
		current_clockfreq = 100;
		hw_set_cpu(100);
#endif
	}
#endif

	fprintf(stderr, "main - Entering mainloop\n");
	int input_hold = 0;
	bool go_on     = true;
	while(go_on)
	{
		SDL_Delay(60);

		app->Update();
		currentState->Update();
#if defined(GP2X) || defined(A320)
		if(count++ == 50)
		{
			count = 0;
			int v = hw_get_voltage();
			volt = (volt * 15 + v)>>4;
        		app->lcd->SetLed(LedControl::VOLT, (v-18)*2/3);
#ifdef A320
			app->lcd->SetLed(LedControl::EQ0, (current_clockfreq)/21);
#else
			app->lcd->SetLed(LedControl::EQ0, (current_clockfreq*2)/25);
#endif
		}
		if(display_on)
#endif
			app->Render();

        int key = input->GetKey(60);
		if(key == Input::HOLD || key == Input::HOLD_BLANK )
		{
			input_hold ^= 1;
			app->lcd->SetLed(LedControl::HOLD, input_hold);
#if defined(GP2X) || defined(A320)
            if( key == Input::HOLD_BLANK ) {
                display_on ^= 1;
    			hw_set_screen((bool)display_on);
            }
#endif
		}
		if(!input_hold && key)
		{
            // I'm running short on buttons.. wish i didn't 
            // have to resort to this.. but what the hell..
            if((currentState == &g_playlistState || currentState == &g_browserState)
                && (key == Input::LENGTHUP || key == Input::LENGTHDOWN))
            {
                currentState->HandleKey(key);
            }
            else
			if(go_on = app->HandleKey(key))
			{
				if(key == Input::PLAYLIST)
				{
					if(currentState != &g_playlistState)
						currentState = &g_playlistState;
					else
						currentState = &g_browserState;
					currentState->Enter();
				}
				else if (key == Input::SAVE)
                {
                    if(currentState != &g_saveState)
                        currentState = &g_saveState;
                    else
                        currentState = &g_browserState;
                    currentState->Enter();
                }
                else
					currentState->HandleKey(key);
#if defined(GP2X) || defined(A320)
				if(key == Input::BLANK)
				{
					display_on ^= 1;
					hw_set_screen((bool)display_on);
				}
				else if(key == Input::SPEED && app->cpu_scaling)
				{
#ifdef A320
                                        if((current_clockfreq -= 12) < 200)
						current_clockfreq = 200;
#else
					if((current_clockfreq -= 25) < 50)
						current_clockfreq = 250;
#endif
                    fprintf(stderr, "main - Setting clockfreq to %d\n",current_clockfreq);
					hw_set_cpu(current_clockfreq);
					app->lcd->SetLed(LedControl::EQ0, (current_clockfreq*2)/25);
				}
                else 
#endif
                if(key == Input::QUIT)
                {
                    fprintf(stderr, "main - Quit signal, closing audio\n");
                    if(aopen)
                        SDL_CloseAudio();
                    SDL_Quit();
                    go_on = false;
                }
			}
		}
	}
    fprintf(stderr, "main - Main loop done, cleaning up and leaving\n");
#if defined(GP2X) || defined(A320)
	if(!display_on)
		hw_set_screen(true);
#endif
	delete app;
	return 0;
}
