/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    2010 gama - Added blargg's File_Extractor library support.
    */
#ifndef FEXFILELIST_H
#define FEXFILELIST_H

#include "Files.h"
#include "FileList.h"
#include "fex/fex.h"

using namespace std; 

// Maintain same class name to avoid changes in other files

class ZipDir
{
public:
	ZipDir(char *fname) : filename(fname) {}
	string filename;
	vector<unsigned short> files;
	vector<ZipDir*> dirs;
};

class ZipFileList : public IFileList
{
    public:
        ZipFileList(const char *source, int (*fcb)(void *, const char *) = NULL, void *data = NULL);
        ~ZipFileList();

        virtual const char *GetName(int index)  { return filerefs[index].name.c_str(); }
        virtual const char *GetPath(int index)  { return filerefs[index].path.c_str(); }
        virtual int         GetSize(int index)  { return filerefs[index].size; }
        virtual int         GetTime(int index)  { return filerefs[index].time; }
        virtual int         GetIndex(int index) { return filerefs[index].index; }
        virtual int         GetTrack(int index) { return filerefs[index].track; }
        int                 Size()              { return filerefs.size(); }
        virtual void        SetTrack(int track) { filerefs[marked].track = track; }
        virtual void        SetTime(int time)   { filerefs[marked].time = time; }
        virtual int Enter(int index);
        virtual void SetFilterFunc(int (*fcb)(void *, const char *), void *data)
        {
            filter_cb = fcb;
            cb_data = data;
        }
        
        const char *GetCurDir();

    protected:
        void Enter(const char *dirname);
        void *GetZipReference(int index);

        int (*filter_cb)(void *, const char *);
        void *cb_data;
        int dircount;
        bool dirty;
        ZipDir *curdir;
        fex_t* fex;
        char zipname[128];
};

#endif
