/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */

class IState
{
    public:
        virtual void Enter() {}
        virtual void Exit() {}
        virtual bool Update() { return true; }
        virtual bool HandleKey(int key) { return true; }
};

class BrowserState : public IState
{
    public:
        BrowserState();
        void Enter();
        bool HandleKey(int key);

    private:
        void AppendPlayList(const char* fname);
};

class SaveState : public IState
{
    public:
        SaveState();
        void Enter();
        bool HandleKey(int key);
};

class PlayListState : public IState
{
    public:
        PlayListState();
        void Enter();
        bool HandleKey(int key);
};
