/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#include <SDL/SDL.h>
#include <vector>
#include "FileList.h"
#include "PlayList.h"
#include "SDLScreen.h"
#include "MusicPlayer.h"
#include "Input.h"
#include "Config.h"
#include "M3uPlayList.h"
#include "PlayerApp.h"
#include "util.h"
#include "State.h"
#include "zip/zip.h"

#ifndef _WIN32
#define stricmp strcasecmp
#define strnicmp strncasecmp
#endif


SaveState g_saveState;
extern PlayerApp *app;
static int parent_selected = 0;
static IFileList *parent_file_list = NULL;
static IFileList *file_list;

// Depends on font width, I should fix this... works fine most of the time
#define TITLEMAXLEN (38)
static char temp_title[TITLEMAXLEN] = " Save playlist ";
inline char* maketitle()
{
    const char *curdir = app->save_list->GetCurDir();
    int dirlen = strlen(curdir);
    if (dirlen > TITLEMAXLEN - 16)
    {
        strcpy(&temp_title[15],"...");
        strcpy(&temp_title[18],curdir+dirlen-TITLEMAXLEN+18);
    }
    else
        strcpy(&temp_title[15],curdir);
}


SaveState::SaveState() {}

void SaveState::Enter()
{
    //fprintf(stderr, "SaveSate::Enter - Changing to SaveList view\n");
	app->pane->SetList(app->save_list);
    maketitle();
    app->pane->SetTitle(temp_title);
    app->pane->SetTitleColor(app->settings.colors[Screen::COL_SAVELIST_TITLE0], app->settings.colors[Screen::COL_SAVELIST_TITLE1]);
}

bool SaveState::HandleKey(int key)
{
    ListPane *pane = app->pane;
    int selected = -1;
    IFileList *current_list = pane->GetList();

    if(key)
    {
        switch(key)
        {
            case Input::PGUP:
                pane->DoCommand(ListPane::PGUP);
                break;
            case Input::PGDOWN:
                pane->DoCommand(ListPane::PGDN);
                break;
            case Input::UP:
                pane->DoCommand(ListPane::UP);
                break;
            case Input::DOWN:
                pane->DoCommand(ListPane::DOWN);
                break;
            case Input::ENTER:
                selected = current_list->Marked();
                break;
            case Input::BACK:
                selected = -2;
                break;
        }
    }

    if(selected == -1)
        return true;

    if(selected < 0)
    {
        int rc = current_list->Enter(-1);
        if(rc < 0)
        {
            delete current_list;
            current_list = parent_file_list;
            rc = parent_selected;
            parent_selected = 0;
            parent_file_list = NULL;
        }
        pane->SetList(current_list);
        maketitle();
        pane->SetTitle(temp_title);
        if(rc >= 0)
            current_list->SetMarked(rc);
        pane->DoCommand(ListPane::NOTHING);
    }
    else
    {
        int fsize = current_list->GetSize(selected);
        const char *name = current_list->GetName(selected);
        if(fsize == -1)
        {
            current_list->Enter(selected);
            pane->SetList(current_list);
            maketitle();
            pane->SetTitle(temp_title);
            current_list->SetMarked(0);
            current_list->SetStart(0);
            pane->DoCommand(ListPane::NOTHING);
            selected = -1;
        }
        else
        {
            fprintf(stderr, "SaveState::HandleKey - Saving playlist as %s\n",
                            current_list->GetPath(selected));
            app->play_list->Save(current_list->GetPath(selected));
            app->save_list->ReloadCurDir();
            app->pane->DoCommand(ListPane::NOTHING);
        }
    }
    return true;
}

