/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef SAVELIST_H
#define SAVELIST_H

#include "Files.h"

class SaveList : public IFileList
{
    public:
        SaveList(char *source, int (*fcb)(void *, const char *) = NULL, void *data = NULL);
        virtual ~SaveList() {}

        virtual const char *GetName(int index)  { return filerefs[index].name.c_str(); }
        virtual const char *GetPath(int index)  { return filerefs[index].path.c_str(); }
        virtual int         GetSize(int index)  { return filerefs[index].size; }
        virtual int         GetTime(int index)  { return -1; }
        virtual int         GetIndex(int index) { return -1; }
        virtual int         GetTrack(int index) { return -1; }
        int                 Size()              { return filerefs.size(); }
        virtual void        SetTrack(int index) { }
        virtual void        SetTime(int index)  { }

        void ReloadCurDir();
        virtual int Enter(int index);
        virtual int Flagged(int x) { return 0; }
        const char *GetCurDir() { return curdir; }
        virtual void SetFilterFunc(int (*fcb)(void *, const char *), void *data)
        {
            filter_cb = fcb;
            cb_data = data;
        }

    protected:
        void AddDirectory(char *dirname, bool recursive = false);
        void Enter(char *dirname);
        int (*filter_cb)(void *, const char *);
        //std::vector<FileData> filerefs;
        void *cb_data;
        bool dirty;
        char curdir[256];
        int changed;
};

#endif
