/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef _PLAYERAPP_H_
#define _PLAYERAPP_H_

#include "Config.h"
#include "Files.h"
#include "SDLScreen.h"
#include "MusicPlayer.h"

class MusicPlayer;
class PlayList;
class FileList;
class SaveList;
class ZipFileList;
class SongInfoPane;
class LedControl;
class Equalizer;

class PlayerApp
{
    public:
        PlayerApp(char *fname);
        ~PlayerApp();

        bool PlaySong(IFileList *list, int index);
        bool HandleKey(int key);
        bool Update();
        void UpdateInfo();
        void Render();
        void RenderEq();
        void Layout();
        void InitSettings(char *fname);

        Screen::DisplaySettings settings;
        MusicPlayer *music_player;
        PlayList *play_list;
        FileList *file_list;
        SaveList *save_list;
        //ZipFileList *zip_list;
        SongInfoPane *songInfo;
        LedControl *lcd;
        Equalizer *eq ;
        ListPane *pane;
        Config screen_cfg;
        Config config;

        bool repeat;
        bool shuffle;
        bool cpu_scaling;
        bool playing;
        int hmargin;
        int vmargin;
        int sep;
};

#endif
