/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <SDL/SDL.h>
#include <vector>
#include "FileList.h"
#include "ZipFileList.h"
#include "PlayList.h"
#include "SDLScreen.h"
#include "MusicPlayer.h"
#include "Input.h"
#include "Config.h"
#include "PlayerApp.h"
#include "State.h"

PlayListState g_playlistState;

extern PlayerApp *app;

PlayListState::PlayListState()
{
}

void PlayListState::Enter()
{
	app->pane->SetList(app->play_list);
	app->pane->SetTitle(" PlayList");
	app->pane->SetTitleColor(app->settings.colors[Screen::COL_PLAYLIST_TITLE0], 
                             app->settings.colors[Screen::COL_PLAYLIST_TITLE1]);
}

bool PlayListState::HandleKey(int key)
{
	ListPane *pane = app->pane;
	IFileList *current_list = pane->GetList();
	if(key)
	{
		switch(key)
		{
        int m;
		case Input::PGUP:
			pane->DoCommand(ListPane::PGUP);
			break;
		case Input::PGDOWN:
			pane->DoCommand(ListPane::PGDN);
			break;
		case Input::UP:
			pane->DoCommand(ListPane::UP);
			break;
		case Input::DOWN:
			pane->DoCommand(ListPane::DOWN);
			break;
		case Input::ENTER:
            if (current_list->Marked() >= 0)
            {
                app->PlaySong(current_list, current_list->Marked());
                if(app->playing)
                    app->play_list->SetCurrent(current_list->Marked());
                break;
                pane->DoCommand(ListPane::DOWN);
            }
		case Input::BACK:
            if (app->play_list->Current() >= 0)
                pane->DoCommand(ListPane::JUMPTO,app->play_list->Current());
            break;
        case Input::INC_SUBTUNE:
            m = app->play_list->Marked();
            if (m >= 0)
            {
                app->play_list->SetTrack(app->play_list->GetTrack(m)+1);
                pane->DoCommand(ListPane::JUMPTO,m);
            }
			break;
        case Input::DEC_SUBTUNE:
            m = app->play_list->Marked();
            if (m >= 0)
            {
                int t = app->play_list->GetTrack(m);
                if (t >= 0)
                {
                    app->play_list->SetTrack(t-1);
                    pane->DoCommand(ListPane::JUMPTO,m);
                }
            }
			break;
        case Input::LENGTHUP:
            m = app->play_list->Marked();
            if (m >= 0)
            {
                int t = app->play_list->GetTime(m);
                if (t > 0)
                    app->play_list->SetTime(t+5000);
                else
                    app->play_list->SetTime(5000);
                pane->DoCommand(ListPane::JUMPTO,m);
            }
			break;
        case Input::LENGTHDOWN:
            m = app->play_list->Marked();
            if (m >= 0)
            {
                int t = app->play_list->GetTime(m)/5000;
                if (t <= 1)
                    app->play_list->SetTime(-1);
                else
                    app->play_list->SetTime(t*5000 - 5000);
                pane->DoCommand(ListPane::JUMPTO,m);
            }
			break;
		case Input::DELETE:
			if(current_list->Marked() >= 0)
			{
				app->play_list->RemoveFile(current_list->Marked());
				pane->SetList(app->play_list);
			}
			break;
		case Input::PLISTADD:
			if(app->play_list->Current() >= 0 && app->play_list->Current() != app->play_list->Marked())
			{
				app->play_list->MoveFile(app->play_list->Marked(), app->play_list->Current() + 1);
				pane->SetList(app->play_list);
			}
			break;
		}
	}

	return true;
}

