/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <vector>
#include <string>
#include "Files.h"

class PlayList : public IFileList
{
    public:
        PlayList(int (*fcb)(void *, const char *) = NULL, void *data = NULL);
        virtual ~PlayList() {}

        virtual const char *GetName(int index)  { return filerefs[index].name.c_str(); }
        virtual const char *GetPath(int index)  { return filerefs[index].path.c_str(); }
        virtual int         GetSize(int index)  { return filerefs[index].size; }
        virtual int         GetTime(int index)  { return filerefs[index].time; }
        virtual int         GetIndex(int index) { return filerefs[index].index; }
        virtual int         GetTrack(int index) { return filerefs[index].track; }
        int                 Size()              { return filerefs.size(); }

        virtual const char       *GetCurDir()         { return NULL; }
        virtual int         Enter(int index)    { return 0; }
        virtual void        SetFilterFunc(int (*)(void*, const char*), void*) { }

        virtual void        SetTrack(int track) { filerefs[marked].track = track; }
        virtual void        SetTime(int time)   { filerefs[marked].time = time; }
        void AddFile(const char *name, int size, const char *path, 
                     int index = -1, int times = -1, int subtune = -1);
        void RemoveFile(int n);
        void MoveFile(int from, int to);
        int Flagged(int x) { return Current() == x; }
        void SetCurrent(int n);
        int Current();
        int Changed() { return changed; }
        void Prev(bool wrap);
        void Next(bool wrap);
        void Shuffle();
        void SetShuffle(bool on) { shuffle_on = on; Shuffle(); }
        void Clear();
        void Save(const char *name);

    protected:
        int (*filter_cb)(void *, const char *);
        void *cb_data;
        std::vector<int> shuffle_list;
        int current;
        int shuffle_current;
        int changed;
        bool shuffle_on;
        bool shuffled;
};

#endif
