TARGET = oldplay

CFLAGS += -I../include                                  \
          -DPATH_MAX=4096                               \
          -DFB16

ifdef A320
CFLAGS += -DOLDPLAYVERSION="\"v1.12 gama       \""
else
CFLAGS += -DOLDPLAYVERSION="\"v1.31 sasq+micket\""
endif

STATICLIBS = -Wl,-Bstatic,--gc-sections    \
             -L../libs       \
             -lgme           \
             -lsidplay       \
             -lmpg123        \
             -lmodplug       \
             -ladplug        \
             -lbinio         \
             -ltimidity      \
             -lvgmstream     \
             -lFLAC          \
             -lstsound       \
             -lfaad          \
             -luade          \
             -lsc68          \
             -lfaad          \
             -lmp4ff         \
             -ltta           \
             -lwavpack       \
             -lfex
#             -lmpcdec        \
#             -lmac           \
#             -lsexypsf

ifdef STATIC
STATICLIBS += -lid3tag        \
              -lvorbisidec    \
              -lz             \
              -Wl,-Bdynamic -lSDL
endif

ifndef STATIC
DYNAMICLIBS = -Wl,-Bdynamic   \
              -lmad           \
              -lid3tag        \
              -logg           \
              -lvorbisidec    \
	      -lSDL-1.2       \
              -lz
endif

LIBS += $(STATICLIBS) $(DYNAMICLIBS)
#LIBS += $(DYNAMICLIBS) $(STATICLIBS)

OBJS += main.o util.o                                   \
        Config.o Hashtable.o                            \
        PlayerApp.o Input.o MusicPlayer.o Fifo.o        \
        SDLScreen.o Equalizer.o M3uPlayList.o           \
        FileList.o PlayList.o SaveList.o ZipFileList.o  \
        BrowserState.o PlayListState.o SaveState.o      \
	FormatsDatabase.o

MODULES += pogo fft                                                 \
           mpg123plugin vorbisplugin flacplugin         \
           ttaplugin wavpackplugin                      \
           faadplugin vgmstreamplugin                   \
           gmeplugin  sidplugin timidityplugin          \
           adplugin modplugin stsoundplugin             \
           hivelyplugin sc68plugin uadeplugin
#          macplugin mpcplugin                  \
#          sexypsfplugin 

##################### NORMALLY DONT TOUCH ANYTHING BELOW #####################

#LD    = $(PREFIX)g++
#CC    = $(PREFIX)gcc
#CXX   = $(PREFIX)g++
#STRIP = $(PREFIX)strip
# Implicit rules
LD=$(CXX)

$(OBJDIR)/%.o : %.c
	$(CC) -c $(CFLAGS)  $< -o $@

$(OBJDIR)/%.o : %.cpp
	$(CXX) -c $(CFLAGS) $< -o $@

$(OBJDIR)/%.o : %.S
	$(AS) $(ASFLAGS)    $< -o $@

$(OBJDIR)/%.o : %.s
	$(AS) $(ASFLAGS)    $< -o $@
	
$(OBJDIR)/% :
	mkdir -p $@
	
CFLAGS += $(addprefix -I,$(MODULES))

MODULEOBJS  = $(patsubst %.cpp,%.o, $(wildcard $(addsuffix /*.cpp,$(MODULES))))
MODULEOBJS += $(patsubst %.c,  %.o, $(wildcard $(addsuffix /*.c  ,$(MODULES))))

OBJFILES = $(addprefix $(OBJDIR)/,$(OBJS) $(MODULEOBJS))
OBJDIRS  = $(OBJDIR) $(addprefix $(OBJDIR)/, $(MODULES))

all : $(OBJDIRS) $(OBJFILES) $(TARGET)$(EXT) 

$(OBJDIR) :
	mkdir -p $(OBJDIR)

$(TARGET)$(EXT) : $(OBJFILES) $(DEPS)
	$(LD) $(LDFLAGS) -o $(TARGET)$(EXT) $(OBJFILES) $(LIBS)
	$(STRIP) --strip-all --remove-section=.comment --remove-section=.note $(TARGET)$(EXT)
	cp $(TARGET)$(EXT) ../dist/oldplay

clean :
	rm -rf $(OBJFILES) $(TARGET)$(EXT)

