TARGET = oldplay

CFLAGS += -I../include                                  \
          `$(SDL_PREFIX)sdl-config --cflags`            \
          -DPATH_MAX=4096                               \
          -DFB16

ifdef A320
CFLAGS += -DOLDPLAYVERSION="\"v1.12 gama       \""
else
CFLAGS += -DOLDPLAYVERSION="\"v1.31 sasq+micket\""
endif

STATICLIBS = -Wl,-export-dynamic,--gc-sections    \
             -L../libs       \
#             -lgme           \
#             -lmodplug       \
#             -ladplug        \
#             -lbinio         \
#             -lsidplay       \
#             -ltimidity      \
#             -lvgmstream     \
#             -lFLAC          \
#             -luade          \
#             -lstsound       \
#             -lfaad          \
#             -lsc68          \
#             -lfaad          \
#             -lmp4ff         \
#             -lmac           \
#             -lmpcdec        \
#             -lsexypsf       \
#             -ltta           \
#             -lwavpack       \
             
DYNAMICLIBS = `$(SDL_PREFIX)sdl-config --libs` \
              -lid3tag        \
              -lmad           \
	      -logg           \
              -lvorbisidec    \
              -lz \
              -ldl

LIBS += $(STATICLIBS) $(DYNAMICLIBS)
#LIBS += $(DYNAMICLIBS) $(STATICLIBS)

OBJS += main.o util.o                                   \
        Config.o Hashtable.o                            \
        PlayerApp.o Input.o MusicPlayer.o Fifo.o        \
        SDLScreen.o Equalizer.o M3uPlayList.o           \
        FileList.o PlayList.o SaveList.o ZipFileList.o  \
        BrowserState.o PlayListState.o SaveState.o      \
	FormatsDatabase.o

MODULES += pogo fft                                                 \
#           gmeplugin madplugin modplugin adplugin                   \
#           sidplugin timidityplugin flacplugin                      \
#           vgmstreamplugin vorbisplugin uadeplugin                  \
#           stsoundplugin hivelyplugin faadplugin                    \
#           sc68plugin
#          mpcplugin faadplugin ttaplugin                           \
#          macplugin wavpackplugin                                  \
#          sexypsfplugin

PLUGINS = timidityplugin/timidityplugin.so

##################### NORMALLY DONT TOUCH ANYTHING BELOW #####################

LD    = $(PREFIX)g++
CC    = $(PREFIX)gcc
CXX   = $(PREFIX)g++
STRIP = $(PREFIX)strip
# Implicit rules

$(OBJDIR)/%.o : %.c
	$(CC) -fPIC $(CFLAGS) -c -o $@ $<

$(OBJDIR)/%.o : %.cpp
	$(CXX) -fPIC $(CFLAGS) -c -o $@ $<

$(OBJDIR)/%.o : %.S
	$(AS) $(ASFLAGS)    $< -o $@

$(OBJDIR)/%.o : %.s
	$(AS) $(ASFLAGS)    $< -o $@
	
$(OBJDIR)/% :
	mkdir -p $@
	
CFLAGS += $(addprefix -I,$(MODULES))

MODULEOBJS  = $(patsubst %.cpp,%.o, $(wildcard $(addsuffix /*.cpp,$(MODULES))))
MODULEOBJS += $(patsubst %.c,  %.o, $(wildcard $(addsuffix /*.c  ,$(MODULES))))

OBJFILES = $(addprefix $(OBJDIR)/,$(OBJS) $(MODULEOBJS))
OBJDIRS  = $(OBJDIR) $(addprefix $(OBJDIR)/, $(MODULES))

all : $(OBJDIRS) $(OBJFILES) $(TARGET)$(EXT) $(PLUGINS)

$(OBJDIR) :
	mkdir -p $(OBJDIR)

$(TARGET)$(EXT) : $(OBJFILES) $(DEPS)
	$(LD) $(LDFLAGS) $(LIBS) -o $(TARGET)$(EXT) $(OBJFILES) -lfex
	$(STRIP) --strip-all --remove-section=.comment --remove-section=.note $(TARGET)$(EXT)
	mv $(TARGET)$(EXT) ../player

timidityplugin/timidityplugin.so: timidityplugin/timidityplugin.cpp
	$(CC) $(CFLAGS) $(LDFLAGS) $(LIBS) -shared -fpic -o timidityplugin/timidityplugin.so timidityplugin/timidityplugin.cpp -ltimidity
	$(STRIP) --strip-all --remove-section=.comment --remove-section=.note timidityplugin/timidityplugin.so
	mv timidityplugin/timidityplugin.so ../player/plugins

clean :
	rm -rf $(OBJFILES) $(TARGET)$(EXT)

