/* Blah blah blah lincense crap */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "M3uPlayList.h"
#include "Files.h"
#include "util.h"

int parse_time(char* str) // Help function
{
    //printf("parsing time : %s\n",str);
    int write_pos = 0, del_pos = 0;
    for (int i = 0; i < strlen(str); i++)
    {
        if (isdigit(str[i]) ||  str[i] == '-' )
            str[write_pos++] = str[i];
        else if (str[i] == ':')
        {
            del_pos = write_pos+1;
            str[write_pos++] = str[i];
        }
    }
    str[write_pos] = '\0';
    if (!strlen(str+del_pos))
        return -1;

    if (del_pos == 0)
        return atoi(str)*1000;
    return atoi(str)*60000+atoi(str+del_pos)*1000;
}

// Actually supports pls and opl (OldPlayList) as well
M3uPlayList::M3uPlayList(const char* fname) 
{
    fprintf(stderr, "M3uPlayList::M3uPlayList - Opening %s\n",fname);
    FILE* fp = fopen(fname,"r");
    if (!fp)
    {
        fprintf(stderr, "M3uPlayList::M3uPlayList - Couldn't open file %s\n",fname);
        return;
    }
    char line[1024];
    char *dirend = strrchr(fname,SEPARATOR);
    int dirlen = strlen(fname)-strlen(dirend)+1;
    if (is_ext(fname,".m3u")) 
    {
        if(!(fgets(line,1023,fp)))
            return;
        if (line[0] != '#') // Simple
        {
            rewind(fp);
            fprintf(stderr, "M3uPlayList::M3uPlayList - Parsed as simple m3u\n");
            for (;fgets(line,1023,fp);)
            {
                line[strlen(line)-1] = '\0'; // FIXME Is this really needed?
                char path[1024];
                if (*line == SEPARATOR)
                    strcpy(path,line);
                else
                {
                    strncpy(path,fname,dirlen);
                    strcpy(&path[dirlen],line);
                }
                paths.push_back(path);
                names.push_back(strrchr(path,SEPARATOR)+1);
                index.push_back(-1);
                times.push_back(-1);
                tracks.push_back(-1);
            }
        }
        else
        {
            fprintf(stderr, "M3uPlayList::M3uPlayList - Parsed as extended m3u\n");
            for (;fgets(line,1023,fp);)
            {
                line[strlen(line)-1] = '\0';
                if (*line == '#')
                {
                    char *time = strchr(line,':');
                    char *name = strchr(line,',');
                    if (!name || !time)
                        continue;
                    *name = '\0';
                    if (strlen(time+1) < 1)
                        times.push_back(-1);
                    else
                        times.push_back(parse_time(time+1));
                    if (strlen(name+1) < 1)
                        continue;
                    #ifdef M3UDEBUG
                    fprintf(stderr, "M3uPlayList::M3uPlayList - name = %s\n",name+1);
                    #endif
                    names.push_back(string(name+1));
                }
                else
                {
                    char path[1024];
                    if (*line == SEPARATOR)
                        strcpy(path,line);
                    else
                    {
                        strncpy(path,fname,dirlen);
                        strcpy(&path[dirlen],line);
                    }
                    #ifdef M3UDEBUG
                    fprintf(stderr, "M3uPlayList::M3uPlayList - path = %s\n",path);
                    #endif
                    paths.push_back(string(path));
                    index.push_back(-1);
                    tracks.push_back(-1);
                }
            }
        }
    }
    else if (is_ext(fname,".pls"))
    {
        fprintf(stderr, "M3uPlayList::M3uPlayList - Parsed as pls\n");
        for (;fgets(line,1023,fp);)
        {
            line[strlen(line)-1] = '\0';
            char* line2 = strrchr(line,'=');
            if (!line2 || strlen(line2) < 2)
                continue;
            if(line[0] == 'F')
            {
                if (times.size() < paths.size())
                    times.push_back(-1);
                char path[1024];
                if (*(line2+1) == SEPARATOR)
                    strcpy(path,&line2[1]);
                else
                {
                    strncpy(path,fname,dirlen);
                    strcpy(&path[dirlen],&line2[1]);
                }
                paths.push_back(string(path));
                index.push_back(-1);
                tracks.push_back(-1);
            }
            else if (line[0] == 'T')
            {
                /* TODO - Memory leak here? */
                char* name = (char*)malloc(strlen(line2+1)+1);
                strcpy(name,&line2[1]);
                names.push_back(name);
            }
            else if (line[0] == 'L')
                times.push_back(parse_time(line));
        }
    }
    else if (is_ext(fname,".opl"))
    {
        fprintf(stderr, "M3uPlayList::M3uPlayList - Parsed as opl (OldPlayList)\n");
        for (;fgets(line,1023,fp);)
        {
            line[strlen(line)-1] = '\0';
            char* line2 = strrchr(line,'=');
            if (!line2 || strlen(line2) < 2)
                continue;
            if(line[0] == 'F')
            {
                if (times.size() < paths.size())
                    times.push_back(-1);
                if (names.size() < paths.size())
                    names.push_back("Noname");
                if (index.size() < paths.size())
                    index.push_back(-1);
                if (tracks.size() < paths.size())
                    tracks.push_back(-1);
                char path[1024];
                if (*(line2+1) == SEPARATOR)
                    strcpy(path,&line2[1]);
                else
                {
                    strncpy(path,fname,dirlen);
                    strcpy(&path[dirlen],&line2[1]);
                }
                paths.push_back(string(path));
            }
            else if (line[0] == 'T')
                names.push_back(line2+1);
            else if (line[0] == 'I')
                index.push_back(atoi(line2+1));
            else if (line[0] == 'L')
                times.push_back(parse_time(line2+1));
            else if (line[0] == 'S')
                tracks.push_back(atoi(line2+1));
        }
        if (times.size() < paths.size())
            times.push_back(-1);
        if (names.size() < paths.size())
            names.push_back("Noname");
        if (index.size() < paths.size())
            index.push_back(-1);        
        if (tracks.size() < paths.size())
            tracks.push_back(-1);
    }
    if (paths.size() != names.size() || paths.size() != index.size() || 
        paths.size() != times.size() || paths.size() != tracks.size())
    {
        fprintf(stderr, "M3uPlayList::M3uPlayList - Mismatch, (P:T:I:L:S) "
                        "(%d:%d:%d:%d:%d)\n", paths.size(), names.size(), 
                        index.size(), times.size(), tracks.size());
        paths.clear();
        names.clear();
        index.clear();
        times.clear();
        tracks.clear();
    }
    fprintf(stderr, "M3uPlayList::M3uPlayList - Done, %d valid entries\n",
                    paths.size());
    fclose(fp);
}

M3uPlayList::~M3uPlayList()
{
    paths.clear();
    names.clear();
    index.clear();
    times.clear();
    tracks.clear();
}

void M3uPlayList::Next()
{
    if (!paths.size())
        return;
    paths.erase(paths.begin());
    names.erase(names.begin());
    index.erase(index.begin());
    times.erase(times.begin());
    tracks.erase(tracks.begin());
}

