/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef _HASHTABLE_H_
#define _HASHTABLE_H_

class Hashtable
{
    public:
        Hashtable();
        ~Hashtable();
        void Init();
        char*& operator[](const char *s);
        int size();

    protected:
        struct HashEntry
        {
            const char *name;
            char *val;
            struct HashEntry *next;
        };

        HashEntry *symbols[41];
        int m_size;

        unsigned int hash(const char *str);

};

#endif /*_HASHTABLE_H_*/
