/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifdef POGO
#include "pogo/pogo.h"
#else
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#endif

#include "Hashtable.h"

unsigned int Hashtable::hash(const char *str)
{
	unsigned int hash = 0;
	while(*str)
		hash = ((hash<<5)^(hash>>27))^*str++;

	return hash;
}

void Hashtable::Init()
{
	m_size = 41;
	memset(symbols, 0, m_size * sizeof(void *));
}

Hashtable::Hashtable()
{
	Init();
}

Hashtable::~Hashtable()
{
	HashEntry *he, *he2;
	int i;

	for(i=0; i<m_size; i++)
	{
		he = symbols[i];
		while(he)
		{
			he2 = he->next;			
			free(he);			
			he = he2;
		}
	}
}

int Hashtable::size()
{
	HashEntry *he;
	int i;
	int size = 0;

	for(i=0; i<m_size; i++)
	{
		he = symbols[i];
		while(he)
		{
			size++;
			he = he->next;			
		}
	}
	return size;
}

char*& Hashtable::operator[](const char *name)
{
	HashEntry **he;
	int i = hash(name) % m_size;

	he = &symbols[i];
	while(*he && strcmp((*he)->name, name) != 0)
	{
		he = &((*he)->next);
	}

	if(!(*he))
	{
		*he = (HashEntry *)malloc(sizeof(HashEntry));
		(*he)->name = name;
		(*he)->val = 0;
		(*he)->next = 0;
	}
	
	return (*he)->val;
}

