/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef FORMATS_DB_H
#define FORMATS_DB_H

#include <vector>
#include <string>
#include <algorithm>

#include <stdlib.h>
#include <string.h>

using namespace std;

class FormatsDatabase {
    public:
        FormatsDatabase() {};
        ~FormatsDatabase() {};

        // Loads new database
        // id - Database identifier [ID]
        // db - Name of database file
        int Load(const char *id, const char *db);

        // Searches for an item in the database
        // Returns 1 on success, 0 on failure
        int Find(const char *token);

        /* TODO - Must free something? */
        void Free() {};

    private:
        vector <string> formats_db;
};

#endif
