/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */

#include "FormatsDatabase.h"

#define MAX_DB_LENGTH     (4*500)            // 500 formats aprox. (4 chars length each) for each identifier

/* Helper Functions */
bool sort_string (const string &a, const string &b) 
{ 
    return a.compare(b) < 0 ? true : false;
}
 
bool find_string (const string &a, const string &b)
{
    return a.compare(b) == 0 ? true : false;
}

int FormatsDatabase::Load(const char *id, const char *db)
{
    if( id == NULL || db == NULL ) return 0;
    
    // Open database file
    FILE *fp = fopen(db, "rb");
    if( fp == NULL ) return 0;

    // Search for identifier
    char tmp[MAX_DB_LENGTH];
    int found = 0;
    while( fgets(tmp, MAX_DB_LENGTH, fp) != NULL ) {
        if( !strncmp(id, tmp, strlen(id)) ) {
            found = 1;
            break;
        }
    }

    if( found == 0 ) {
        fprintf(stderr, "FormatsDatabase: Couldn't find identifier %s.\n", id);
        fclose(fp);
        return 0;
    }

    formats_db.clear();
    
    // Read for formats 
    fgets(tmp, MAX_DB_LENGTH, fp);
    fclose(fp);

    char *token = strtok(tmp, ",\n");
    while(token != NULL) {
        string fmt = string(token);
        formats_db.push_back(fmt);

        token = strtok(NULL, ",\n");
    }

    // Sort formats alphabetically
    sort(formats_db.begin(), formats_db.end());

    fprintf(stderr, "FormatsDatabase: %s: %d formats found.\n", id, formats_db.size());

    return 1;
}

int FormatsDatabase::Find(const char *token)
{
    return binary_search(formats_db.begin(), formats_db.end(), string(token));
}

