/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef FILES_H
#define FILES_H

#include <vector>
#include <string>

#ifdef _WIN32
#define SEPARATOR '\\'
#else
#define SEPARATOR '/'
#endif

struct FileData
{
    std::string name;
    std::string path;
    int size;
    int time;
    int index;
    int track;
};

class IFileList
{
    public:
        IFileList() : marked(-1), start(0) {};
        virtual ~IFileList() {}

        virtual int         Size()              = 0;
        virtual const char *GetName(int index)  = 0;
        virtual const char *GetPath(int index)  = 0;
        virtual int         GetSize(int index)  = 0;
        virtual int         GetTime(int index)  = 0;
        virtual int         GetIndex(int index) = 0;
        virtual int         GetTrack(int index) = 0;
        virtual void        SetTime(int index)  = 0;
        virtual void        SetTrack(int index) = 0;

        virtual void  SetFilterFunc(int (*fcb)(void *, const char *), void *data) = 0;
        virtual const char *GetCurDir()      = 0;
        virtual int   Enter(int index) = 0;
        virtual int   Flagged(int x)   { return 0; }
        virtual int   Changed()        { return 0; }

        int  Marked()         { return marked; }
        int  Start()          { return start; }
        void SetMarked(int m) { marked = m; }
        void SetStart(int m)  { start = m; }

    protected:
        std::vector<FileData> filerefs;
        int marked;
        int start;
};

#endif
