/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */
#ifndef _FIFO_H_
#define _FIFO_H_

class Fifo
{
    public:
        Fifo(int size);
        ~Fifo();
        int Write(void *src, int size);
        int Read(void *src, int size);
        int Read16(void *dst, int size, int scale = 0x10000);
        unsigned char *GetDest() { return ptr; }
        int LeftToWrite() { return size - (ptr-buffer); }
        int LeftToRead() { return (ptr-buffer); }
        void Reset();

    protected:
        unsigned char *buffer;
        unsigned char *ptr;
        int size;
};

class BlockFifo
{
    public:
        BlockFifo(int bsize, int bcount);
        ~BlockFifo();
        int Write(void *src, int blocks);
        int Read(void *src, int blocks, int peek = 0);
        int Read16(void *dst, int size, int scale = 0x10000);
        int LeftToRead();
        int LeftToWrite();
        void *ExamineNextBlock() { return (void *)readptr; }
        void *WriteTarget(int blocks);
        void *ReadTarget(int blocks);
        void Reset();

    protected:
        unsigned char *readptr;
        unsigned char *writeptr;
        unsigned char *buffer;
        int blocksize;
        int blockcount;
        int wrap;
};

#endif
