/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
    */

#include "SDLScreen.h"

class Equalizer : public Pane
{
    public:
        Equalizer(int x, int y, int w, int h, Screen *scr = NULL);
        bool Update();
        void WriteSamples(short *samples, int len);
        void Resize(int w, int h);
        void ClearBars();

    protected:
        void Setup();

        int max_hi;
        int barcount;
        int barsize ;
        int startpos[32];
        short eq[26];
        short table[16384];
        unsigned int colors[64];
        unsigned int colors2[64];
};
