#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>

#if defined(GP2X)
#include <stropts.h>

#define GPIOAPINLVL 0x1180
#define GPIOBPINLVL 0x1182
#define GPIOCPINLVL 0x1184
#define GPIODPINLVL 0x1186
#define GPIOEPINLVL 0x1188
#define GPIOFPINLVL 0x118A
#define GPIOGPINLVL 0x118C
#define GPIOHPINLVL 0x118E
#define GPIOIPINLVL 0x1190
#define GPIOJPINLVL 0x1192
#define GPIOKPINLVL 0x1194
#define GPIOLPINLVL 0x1196
#define GPIOMPINLVL 0x1198
#define GPIONPINLVL 0x119A
#define GPIOOPINLVL 0x119C

#define GPIOAOUT 0x1060
#define GPIOBOUT 0x1062
#define GPIOCOUT 0x1064
#define GPIODOUT 0x1066
#define GPIOEOUT 0x1068
#define GPIOFOUT 0x106A
#define GPIOGOUT 0x106C
#define GPIOHOUT 0x106E

#define GPIOIOUT 0x1060
#define GPIOJOUT 0x1062
#define GPIOKOUT 0x1064
#define GPIOLOUT 0x1066
#define GPIOMOUT 0x1068
#define GPIONOUT 0x106A
#define GPIOOOUT 0x106C

#define GPIOIOUTF2 0x1070
#define GPIOJOUTF2 0x1072
#define GPIOKOUTF2 0x1074
#define GPIOLOUTF2 0x1076
#define GPIOMOUTF2 0x1078
#define GPIONOUTF2 0x107A
#define GPIOOOUTF2 0x107C
volatile unsigned int *memregs32;
volatile unsigned short *memregs16;

int batt_fd;
bool f200;

void hw_init()
{
    struct stat stFileInfo;
    f200 = false;
    if(stat("/dev/touchscreen/wm97xx",&stFileInfo) == 0)
        f200 = true;

	int memfd = open("/dev/mem", O_RDWR);
	if(memfd >= 0)
		memregs16 = (unsigned short *)mmap(0, 0x10000, PROT_READ|PROT_WRITE, MAP_SHARED, memfd, 0xc0000000);

	memregs32 = (volatile unsigned int *)memregs16;
	fprintf(stderr, "hw_init - %p\n", memregs16);
	fflush(stderr);

	memregs16[0x0924>>1] = 0x8900;// + ((addclock)<<8);

	batt_fd = open("/dev/batt", O_RDONLY);
}

void hw_set_led(bool on)
{
	if(on)
		memregs16[GPIOHOUT >> 1] |= 16;
	else
		memregs16[GPIOHOUT >> 1] &= ~16;
}

void hw_set_screen(bool on)
{
	if(on)
		memregs16[GPIOHOUT >> 1] |= 0x0002;
	else
		memregs16[GPIOHOUT >> 1] &= ~0x002;
}

 
int hw_get_voltage()
{
	int total = 0;
	unsigned short v;
	for(int i=0; i<10; i++)
		if(read(batt_fd, &v, 2) == 2)
			total += v;

	int battval =  total / 10;

	if     (battval > 1016) v = 37;
	else if (battval > 974) v = 33;
	else if (battval > 943) v = 32;
	else if (battval > 915) v = 31;
	else if (battval > 896) v = 30;
	else if (battval > 837) v = 29;
	else if (battval > 815) v = 28;
	else if (battval > 788) v = 27;
	else if (battval > 745) v = 26;
	else if (battval > 708) v = 25;
	else if (battval > 678) v = 24;
	else if (battval > 649) v = 23;
	else if (battval > 605) v = 22;
	else if (battval > 573) v = 21;
	else if (battval > 534) v = 20;
	else if (battval > 496) v = 19;
	else if (battval > 448) v = 18;
	else v = 17;

	return v;
}


#define MSP_INTMASK              (0xC0000808)
//#define pMSP_INTMASK             ((volatile unsigned int *)nMSP_INTMASK)
#define MSP_FPLLSETVREG          (0xC0000910) 
#define MSP_CLKCHGSTREG          (0xC0000902) 

#define SETW(x, n) (*((volatile unsigned short *)x) = n)
#define SETL(x, n) (*((volatile unsigned int *)x) = n)

#define GETW(x)    (*((volatile unsigned short *)x))
#define GETL(x)    (*((volatile unsigned int *)x))

unsigned int sdk2x_SetFPLL(unsigned short FpllSetReg)
{
	int i;
	unsigned int imask;

	imask = GETL(MSP_INTMASK);

//	hw_set_led(true);

	// Mask ALL interrupts
	SETL(MSP_INTMASK, 0xFF8FFFE7);

	SETW(MSP_FPLLSETVREG, FpllSetReg);

	while (GETW(MSP_CLKCHGSTREG) & 1);

	SETL(MSP_INTMASK, imask);

	//for (i=0;(i<10000000) && (GETW(MSP_FPLLVSETREG) != FpllSetReg); i++);
	//return CalcPll (MSP_FPLLVSETREG);

	return 0;
}

#define SYSTEM_CLOCK 2457600
void hw_set_cpu(int speed)
{
	/*int m = 0;
	switch(speed)
	{
	case 275: m = 0x6704; break;
	case 250: m = 0x5D04; break;
	case 225: m = 0x5304; break;
	case 200: m = 0x4904; break;
	case 175: m = 0x3F04; break;
	case 150: m = 0x4901; break;
	case 125: m = 0x3c01; break;
	case 100: m = 0x6502; break;
	case 75:  m = 0x4902; break;
	case 50:  m = 0x6503; break;
	}*/

    int m = (((speed*1000000)/SYSTEM_CLOCK-8)<<8)|4;
    fprintf(stdout, "speed = %d, %X ***********************************\n",speed,m);

	if(m)
	{
		// Get interupt flags
		unsigned int l = memregs32[0x808>>2];

		// Turn off interrupts
		memregs32[0x808>>2] = 0xFF8FFFE7;

		// Set new clock frequency
		memregs16[0x910>>1]=m;

		// Wait for it to take
		while(memregs16[0x0902>>1] & 1);

		// Turn on interrupts again
		memregs32[0x808>>2] = l;
	}

}
#elif defined(A320)

/* Define this to the CPU frequency */
#define CPU_FREQ 336000000    /* CPU clock: 336 MHz */
#define CFG_EXTAL 12000000    /* EXT clock: 12 Mhz */

// SDRAM Timings, unit: ns
#define SDRAM_TRAS		45	/* RAS# Active Time */
#define SDRAM_RCD		20	/* RAS# to CAS# Delay */
#define SDRAM_TPC		20	/* RAS# Precharge Time */
#define SDRAM_TRWL		7	/* Write Latency Time */
#define SDRAM_TREF	        15625	/* Refresh period: 4096 refresh cycles/64ms */ 
//#define SDRAM_TREF      7812  /* Refresh period: 8192 refresh cycles/64ms */

#include "jz4740.h"

#define MASK_GPIO2	0x00020000
#define MASK_GPIO3	0x284EC067

static unsigned long jz_dev=0;
static volatile unsigned long  *jz_cpmregl, *jz_emcregl;
volatile unsigned short *jz_emcregs; 

static FILE *batt_fp;
static int lcd_backlight;

static unsigned long		dev_gpio = 0;
static volatile unsigned long	*gpioregl;

inline int sdram_convert(unsigned int pllin,unsigned int *sdram_freq)
{
	register unsigned int ns, tmp;
 
	ns = 1000000000 / pllin;
	/* Set refresh registers */
	tmp = SDRAM_TREF/ns;
	tmp = tmp/64 + 1;
	if (tmp > 0xff) tmp = 0xff;
        *sdram_freq = tmp; 

	return 0;

}
 
void pll_init(unsigned int clock)
{
	register unsigned int cfcr, plcr1;
	unsigned int sdramclock = 0;
	int n2FR[33] = {
		0, 0, 1, 2, 3, 0, 4, 0, 5, 0, 0, 0, 6, 0, 0, 0,
		7, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0,
		9
	};
	//int div[5] = {1, 4, 4, 4, 4}; /* divisors of I:S:P:L:M */
  	int div[5] = {1, 3, 3, 3, 3}; /* divisors of I:S:P:L:M */
	int nf, pllout2;

	cfcr = CPM_CPCCR_CLKOEN |
		(n2FR[div[0]] << CPM_CPCCR_CDIV_BIT) | 
		(n2FR[div[1]] << CPM_CPCCR_HDIV_BIT) | 
		(n2FR[div[2]] << CPM_CPCCR_PDIV_BIT) |
		(n2FR[div[3]] << CPM_CPCCR_MDIV_BIT) |
		(n2FR[div[4]] << CPM_CPCCR_LDIV_BIT);

	pllout2 = (cfcr & CPM_CPCCR_PCS) ? clock : (clock / 2);

	/* Init UHC clock */
    	jz_cpmregl[0x6C>>2] = pllout2 / 48000000 - 1;

	nf = clock * 2 / CFG_EXTAL;
	plcr1 = ((nf - 2) << CPM_CPPCR_PLLM_BIT) | /* FD */
		(0 << CPM_CPPCR_PLLN_BIT) |	/* RD=0, NR=2 */
		(0 << CPM_CPPCR_PLLOD_BIT) |    /* OD=0, NO=1 */
		(0x20 << CPM_CPPCR_PLLST_BIT) | /* PLL stable time */
		CPM_CPPCR_PLLEN;                /* enable PLL */          

	/* init PLL */
      	jz_cpmregl[0] = cfcr;
    	jz_cpmregl[0x10>>2] = plcr1;
	
  	sdram_convert(clock,&sdramclock);
  	if(sdramclock > 0)
  	{
      	jz_emcregs[0x8C>>1] = sdramclock;
    	jz_emcregs[0x88>>1] = sdramclock;	

  	}else
  	{
  	printf("sdram init fail!\n");
  	while(1);
  	} 
	
}

void hw_init()
{
	batt_fp = fopen("/proc/jz/battery", "rb");
	lcd_backlight = 80;

	char buf[12];
	FILE *fp = fopen("/proc/jz/lcd_backlight", "rb");
	if( fp ) {
		fgets(buf, 12, fp);
		fclose(fp);
 		sscanf(buf, "%d", &lcd_backlight);
	}

	dev_gpio = open("/dev/mem", O_RDWR);
        gpioregl=(unsigned long  *)mmap(0, 0x300, PROT_READ|PROT_WRITE, MAP_SHARED, dev_gpio, 0x10010000);
}

void hw_set_led(bool on)
{
}

void hw_set_screen(bool on)
{
	char buf[128];
	sprintf(buf, "echo %d >/proc/jz/lcd_backlight", 
		on == true ? lcd_backlight : 0);
	system(buf);
}
 
int hw_get_voltage()
{
	int mvolts=0,v=0;
	char buf[6]={};
	
        if( batt_fp ) {
		fseek(batt_fp, 0, SEEK_SET);
		fgets(buf, 5, batt_fp);
	 	sscanf(buf, "%d", &mvolts);
	}

	int battval =  (mvolts-3000);

	if     (battval > 1016) v = 37;
	else if (battval > 974) v = 33;
	else if (battval > 883) v = 32;
	else if (battval > 815) v = 31;
	else if (battval > 796) v = 30;
	else if (battval > 637) v = 29;
	else if (battval > 615) v = 28;
	else if (battval > 588) v = 27;
	else if (battval > 545) v = 26;
	else if (battval > 408) v = 25;
	else if (battval > 478) v = 24;
	else if (battval > 349) v = 23;
	else if (battval > 305) v = 22;
	else if (battval > 273) v = 21;
	else if (battval > 234) v = 20;
	else if (battval > 196) v = 19;
	else if (battval > 148) v = 18;
	else v = 17;

	return v;
}

void hw_set_cpu(int speed)
{
	if (speed >= 200 && speed <= 430)
	{
		if(!jz_dev)  jz_dev = open("/dev/mem", O_RDWR);  
		jz_cpmregl=(unsigned long  *)mmap(0, 0x80, PROT_READ|PROT_WRITE, MAP_SHARED, jz_dev, 0x10000000);
		jz_emcregl=(unsigned long  *)mmap(0, 0x90, PROT_READ|PROT_WRITE, MAP_SHARED, jz_dev, 0x13010000);
		jz_emcregs=(unsigned short *)jz_emcregl;
		pll_init(speed*1000000);
		munmap((void *)jz_cpmregl, 0x80); 
		munmap((void *)jz_emcregl, 0x90); 	
		close(jz_dev); jz_dev = 0;
	}
}

#define POWER_MASK	0x20000000
unsigned int hw_read_power_switch_click()
{
	static unsigned long last = 0;

	/* Read GPIO register */
	unsigned long gpio3 = gpioregl[0x300>>2];

	/* gpio pxpin is active low, so flip bits */
	gpio3 ^= 0xffffffff;

	/* mask the bits that we want */
	gpio3 &= MASK_GPIO3;

	if( (gpio3 & POWER_MASK) ) {
	    if( last & POWER_MASK ) {
		    last = gpio3;
		    return 0;
	    }
	    else {
		    last = gpio3;
		    return 1;
	    }
  	}

	last = gpio3;

	return 0;
}

#define HOLD_MASK   0x00400000
unsigned int hw_read_hold_switch_click()
{
	static unsigned long last = 0;

	/* Read GPIO registers */
	//unsigned long gpio2 = gpioregl[0x200>>2];
	unsigned long gpio3 = gpioregl[0x300>>2];

	/* gpio pxpin is active low, so flip bits */
	//gpio2 ^= 0xffffffff;
	gpio3 ^= 0xffffffff;

	/* mask the bits that we want */
	gpio3 &= MASK_GPIO3;

    // Switch on
	if( (gpio3 & HOLD_MASK) ) {
	    if( last & HOLD_MASK ) {
		    last = gpio3;
		    return 0; 
	    }
	    else {
		    last = gpio3;
		    return 1;
	    }
  	}

    // Switch off
    if( last & HOLD_MASK ) {
        last = gpio3;
        return 1;
    }

	last = gpio3;

	return 0;
}

#endif
