/*  Copyright 2006 Jonas Minnberg

    This file is part of OldPlay - a portable, multiformat musicplayer.

    OldPlay is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    OldPlay is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OldPlay; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifdef POGO
#include "pogo/pogo.h"
#else
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#endif

#include "Config.h"

void Config::Init(char *name)
{
	Hashtable::Init();
	m_name = strdup(name);
}

int Config::cmp_func(const void *a0, const void *a1)
{
	HashEntry *he0 = *((HashEntry **)a0);
	HashEntry *he1 = *((HashEntry **)a1);
	
	//fprintf(stderr, "%p %p\n", he0, he1);	
	
	return strcmp(he0->name, he1->name);
}

bool Config::Save()
{
	int i;
	HashEntry *he;
	HashEntry *entries[100];
	HashEntry **start = &entries[1];
	HashEntry **ptr = start;

	fprintf(stderr, "Config::Save - Hashsize %d\n", m_size);

	for(i=0; i<m_size; i++)
	{
		he = symbols[i];
		while(he)
		{
			if(he->val)
				*ptr++ = he;
			fprintf(stderr, "Config::Save - %s\n", he->name);	
			he = he->next;			
		}
	}
	
	*ptr = (HashEntry *)0x33333333;
	entries[0] = (HashEntry *)0x77777777;
	
	fprintf(stderr, "Config::Save - Sorting %d entries\n", ptr - start);

	qsort(start, ptr - start, sizeof(void *),cmp_func);
	fprintf(stderr, "Config::Save - DONE\n");
	
	FILE *fp = fopen(m_name, "wb");
	if(fp)
	{
		for(i=0; i<(ptr-start); i++)
			fprintf(fp, "%s=%s\n", start[i]->name, start[i]->val);			
		fclose(fp);
	}
		
	return true;	
}

bool Config::Load()
{
	char line[80];
	char *val;
	char *ptr;

	FILE *fp = fopen(m_name, "rb");

	if(fp)
	{
		while(fgets(line, sizeof(line), fp))
		{
			ptr = line;
			
			while(*ptr && (*ptr != '=')) ptr++;
			if(*ptr)
			{
				*ptr = 0;
				val = ++ptr;
				while(*ptr && (*ptr != 10) && (*ptr != 13)) ptr++;
				*ptr = 0;
				
				(*this)[strdup(line)] = strdup(val);
				//if(p)
				//	free(p);
				//p = strdup(val);
			}
		}
		fclose(fp);
		return true;
	}
		
	return false;
}

/*
int main(int argc, char **argv)
{
	Config c("test.cfg");
	
	c["FONT0"] = "fonts/arial12.font";
	c["FONT1"] = "fonts/arial12i.font";
	c["FONT2"] = "fonts/arial12b.font";

//	c.Load();
	
	printf("%s\n", c["FONT0"]);
	printf("%s\n", c["FONT1"]);
	printf("%s\n", c["FONT2"]);

	c["FONT0"] = "fonts/arial10.font";
	c["FONT1"] = "fonts/arial10i.font";
	c["FONT2"] = "fonts/arial10b.font";
	
	c.Save();
	
}
*/
