
/*  Input Plugin for GameMusicGear ~
 *  Copyright (C) 2005 - 2010 gama, rockMax
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Default headers */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pspkernel.h>
#include <pspaudio.h>
#include <pspaudiolib.h>

#include "../plugin.h"

#define _SPSF_TYPES_H__
#include "driver.h"

#include "spu/externals.h"
#include "xsflib.h"

PSP_MODULE_INFO("IN_PSF", 0, 1, 1);
PSP_NO_CREATE_MAIN_THREAD();
PSP_HEAP_SIZE_KB( (7 * 1024) + 512 + 512 + 256);

int module_start(SceSize argc, void* argp)
{
 	return 0;
}

int module_stop(int args, void *argp)
{
	return 0;
}

/* Prototypes */
void 	init(void);
void 	reset(void);
int 	load( char *filename );
int 	load_rw( char *file, char *addr, int size );
void 	cleanup( void );
int 	write_buffer( signed short *dest, int len );
void 	get_song_title( char *filename, char **title, int *length );

void get_packet(void);
void send_packet(void);
/* End Prototypes */

/* Variables */

// Taken from sexypsf for psp (yaunaro)
#define SAMPLE_COUNT PSP_AUDIO_SAMPLE_ALIGN(1024)
#define SAMPLE_SIZE  (SAMPLE_COUNT * 4)
#define BUFFER_COUNT 8
#define BUFFER_SIZE  (SAMPLE_SIZE * 8)

static int audio_thread_id;       // ǥåɤ ID
static u8 audio_thread_exit_flag; // ǥåɤνλե饰
static int sexy_thread_id;        // ߥ졼󥹥åɤ ID
static u8 sexy_thread_exit_flag;  // ߥ졼󥹥åɤνλե饰

// static u8 sound_buffer[BUFFER_COUNT][BUFFER_SIZE]; // ɥХåե
// static u8 sound_buffer_ready[BUFFER_COUNT];        // ɥХåեƤ뤫ե饰
static u8 **sound_buffer = NULL;
static u8 *sound_buffer_ready = NULL;

static u8 sound_read_index;                        // ɥХåեɤ߹ߥǥå
static u32 sound_read_offset;                      // ɥХåեɤ߹ߥեåȡ
static u8 sound_write_index;                       // ɥХåեν񤭹ߥǥå
static u32 sound_write_offset;                     // ɥХåեν񤭹ߥեåȡ

static long  total_samples;
static short _vbuf[4096];

PSFINFO *psf_info = NULL;
int thread_paused = 0;

// Required
int channels = 2;
int samplerate = 44100;
AFormat aformat = FMT_S16_LE;
int kbps = 128;

char title[128];
char artist[128];
char album[128];
char copyright[128];
char format[128];

long length;
int subtunes;

/* End Variables */

/** START of Plugin definitions setup */
InputPlugin itable =
{
	/* Populated by Plugin */
	"SexyPSF (Playstation X)",				/* The description of the input plugin */

	init,							/* Called when the plugin is loaded */
	reset, 							/* Called when need to update config */
	load,							/* Load the file */
	load_rw,						/* Load the file from data */
	NULL,							/* Set song subtune */
	NULL,							/* Seek to the specified time */
	NULL,							/* Set the equalizer, most plugins won't be able to do this */
	cleanup,						/* Called when gmgear exit */
	NULL, 							/* Fill audio buffer */
	get_song_title,					/* Function to grab the title string */

	get_packet,						/* Called when need main app data packet*/
	send_packet,					/* Send data packet to main app */

	NULL,
	NULL,							/* Filled by Main App */
	NULL,							/* Filled by Main App */
	0,								/* Filled by Main App */
	LATIN,							/* Filled by Main App */
	STANDALONE_PLAYER				/* Player type */
};
/** END of Plugin definitions setup */

/** Single Plugin Export */
InputPlugin *get_iplugin_info()
{
	return &itable;
}

/* Extra functions */
char *_get_base( char *filename )
{
    char base[256];
    char *tmp = strrchr(filename, '.');
    if( tmp ) {
        strncpy(base, filename, strlen(filename) - strlen(tmp));
		base[strlen(filename)-strlen(tmp)] = '\0';

		char *tmp2 = strrchr(base, '/');
        if( tmp2 ) strcpy(base, tmp2+1);
		return strdup(base);
    }

	return strdup("<null>");
}

static u8 _vcount = 0;
inline void sexyd_visual(short *buffer, int length)
{
	if( _vcount++ > 2 ) {
		memcpy(_vbuf, buffer, length);
		_vcount = 0;
	}
}

/* TODO - support boost option
void sexyd_boost(void *dst, int size, int scale)
{
	int len = size >> 1;
	short *d = (short *)dst;
	while(len--)
		*d = ((*d++) * scale) >> 16;
}
*/

static int audio_thread(SceSize args, void *argp)
{
	sceAudioSRCChReserve(SAMPLE_COUNT, iDownsample22k ? 22050: 44100, 2);
	while(!audio_thread_exit_flag)
	{
		sceKernelDelayThread(10000);

		if(!sound_buffer_ready[sound_read_index]) {
			continue;
		}

		/* TODO - volume boost audio
		sexyd_boost(&sound_buffer[sound_read_index][sound_read_offset],
			1024, 5 * 0x10000 / 10);
		*/

		sceAudioSRCOutputBlocking(PSP_AUDIO_VOLUME_MAX,
			&sound_buffer[sound_read_index][sound_read_offset]);

		sound_read_offset += SAMPLE_SIZE;
		total_samples += 2048;

		/* VISUALIZER BUFFER */
		sexyd_visual((short *)&sound_buffer[sound_read_index][sound_read_offset], 2048);

		if(sound_read_offset >= BUFFER_SIZE) {
			sound_buffer_ready[sound_read_index] = 0;
			sound_read_index++;
			sound_read_offset = 0;

			if(sound_read_index >= BUFFER_COUNT) {
				sound_read_index = 0;
			}
		}
	}

	while(sceAudioOutput2GetRestSample() > 0);
	sceAudioSRCChRelease();

	sceKernelExitThread(0);
	return 0;
}

static int sexy_thread(SceSize args, void *argp)
{
	sexy_execute();
	sceKernelExitThread(0);
	return 0;
}

void sexyd_update(u8 *buffer, int length)
{
	int buffer_free_length;

	do
	{
		sceKernelDelayThread(10);

		if(sexy_thread_exit_flag) {
			sexy_stop();
			return;
		}

next:;
	} while(sound_buffer_ready[sound_write_index]);

	buffer_free_length = BUFFER_SIZE - sound_write_offset;

	if(buffer_free_length >= length) {
		memcpy(&sound_buffer[sound_write_index][sound_write_offset], buffer, length);

		sound_write_offset += length;
	} else {
		memcpy(&sound_buffer[sound_write_index][sound_write_offset], buffer, buffer_free_length);

		buffer += buffer_free_length;
		length -= buffer_free_length;

		sound_buffer_ready[sound_write_index] = 1;
		sound_write_index++;
		sound_write_offset = 0;

		if(sound_write_index >= BUFFER_COUNT) {
			sound_write_index = 0;
		}

		goto next;
	}
}
/* End extra functions */

void init(void)
{
	strcpy(format, "PSF");
	subtunes = 1;

	channels 	= channels;
	samplerate  = samplerate;
	kbps 		= 0x6C;
	aformat 	= FMT_S16_LE;

	psf_info = NULL;
	memset(_vbuf, 0, 4096);

	// Allocate buffers
	sound_buffer = (u8 **)malloc(BUFFER_COUNT * sizeof(u8*));
	if( sound_buffer == NULL ) sceKernelExitGame();

	int i;
	for(i=0;i<BUFFER_COUNT;i++) {
		sound_buffer[i] = (u8*)malloc(BUFFER_SIZE * sizeof(u8));
		if( sound_buffer[i] == NULL ) sceKernelExitGame();
	}

	sound_buffer_ready = (u8 *)malloc(BUFFER_COUNT * sizeof(u8));
	if( sound_buffer_ready == NULL ) sceKernelExitGame();

	itable.in_packet->ID = NO_PACKET;
}

void reset(void)
{
	// Read parameter from config file
	iDownsample22k = ReadBoolValue("downsample_22k", itable.config);
	iUseReverb = ReadIntValue("reverb_effect", itable.config);
	iUseInterpolation = ReadIntValue("interpolation_effect", itable.config);
	// iUseDBufIrq = ReadBoolValue("use_dbuf_irq", itable.config);

	strcpy(title, "");
	strcpy(album, "");
	strcpy(copyright, "");
	strcpy(artist, "");

	samplerate = iDownsample22k ? 22050 : 44100;

	length = 0;
	total_samples = 0;

	if( psf_info != NULL ) {
		if( thread_paused ) {
			sceKernelResumeThread(sexy_thread_id);
		}

		sexy_thread_exit_flag = 1;
		sceKernelWaitThreadEnd(sexy_thread_id, 0);
		sceKernelDeleteThread(sexy_thread_id);

		sexy_freepsfinfo(psf_info);
		psf_info = 0;
		thread_paused = 0;
	}
}

int load( char *file )
{
	psf_info = sexy_load(file);
	if( psf_info == NULL ) {
		return 0;
	}

	int i;
	for(i = 0; i < BUFFER_COUNT; i++)
	{
		memset(sound_buffer[i], 0, BUFFER_SIZE);
		sound_buffer_ready[i] = 0;
	}

	sound_read_index   = 0;
	sound_read_offset  = 0;
	sound_write_index  = 0;
	sound_write_offset = 0;

	/* Set priority of new thread to the same as the current thread */
	SceKernelThreadInfo status;
	int priority = 32;
	status.size = sizeof(SceKernelThreadInfo);
	if (sceKernelReferThreadStatus(sceKernelGetThreadId(), &status) == 0) {
		priority = status.currentPriority;
	}

	// ǥåɤȳϡ
	audio_thread_id = sceKernelCreateThread("audio_thread", audio_thread,
						16, 0x1000, PSP_THREAD_ATTR_USER, 0);
	audio_thread_exit_flag = 0;
	sceKernelStartThread(audio_thread_id, 0, 0);

	// ߥ졼󥹥åɤȳϡ
	sexy_thread_id = sceKernelCreateThread("sexy_thread", sexy_thread,
						priority, 0x1000, PSP_THREAD_ATTR_USER, 0);
	sexy_thread_exit_flag  = 0;
	sceKernelStartThread(sexy_thread_id, 0, 0);

	thread_paused = 1;
	sceKernelSuspendThread(sexy_thread_id);
	sceKernelSuspendThread(audio_thread_id);

	length = psf_info->length > 0 ? psf_info->length : 200000;
	if( psf_info->title ) strncpy(title, psf_info->title, 128);
	if( psf_info->game ) strncpy(album, psf_info->game, 128);
	if( psf_info->artist ) strncpy(artist, psf_info->artist, 128);
	if( psf_info->copyright ) strncpy(copyright, psf_info->copyright, 128);

	return 1;
}

static char psf_filename[256];
static char *psf_addr;
static int   psf_size;
int ex_load_rw( struct XSFLibN *libs );
int load_rw( char *file, char *addr, int size )
{
	/* Hack: to allow psflibn data be requested first */
	psf_addr = (char*)malloc(size*sizeof(char));
	if( psf_addr == NULL ) return 0;
	psf_size = size;

	memcpy(psf_addr, addr, size);
	strncpy(psf_filename, file, 256);

/*  Angelique Special asks for psflib and
	doesnt have the minipsf extension :(.
	const char *tmp = strrchr(file, '.');
	if( tmp && !stricmp(tmp, ".psf") ) {
		return ex_load_rw(NULL);
	}
*/
	itable.in_packet->ID = CMD_REQUEST_XSFLIBN;
	return 1;
}

int ex_load_rw( struct XSFLibN *libs )
{
	sexy_setpsflibs(libs);

	psf_info = sexy_memload(psf_addr, psf_size);
	free(psf_addr);

	if( psf_info == NULL ) {
		return 0;
	}

	int i;
	for(i = 0; i < BUFFER_COUNT; i++)
	{
		memset(sound_buffer[i], 0, BUFFER_SIZE);
		sound_buffer_ready[i] = 0;
	}

	sound_read_index   = 0;
	sound_read_offset  = 0;
	sound_write_index  = 0;
	sound_write_offset = 0;

	/* Set priority of new thread to the same as the current thread */
	SceKernelThreadInfo status;
	int priority = 32;
	status.size = sizeof(SceKernelThreadInfo);
	if (sceKernelReferThreadStatus(sceKernelGetThreadId(), &status) == 0) {
		priority = status.currentPriority;
	}

	audio_thread_id = sceKernelCreateThread("audio_thread", audio_thread,
						16, 0x1000, PSP_THREAD_ATTR_USER, 0);
	audio_thread_exit_flag = 0;
	sceKernelStartThread(audio_thread_id, 0, 0);

	sexy_thread_id = sceKernelCreateThread("sexy_thread", sexy_thread,
						priority, 0x1000, PSP_THREAD_ATTR_USER, 0);
	sexy_thread_exit_flag  = 0;
	sceKernelStartThread(sexy_thread_id, 0, 0);

	thread_paused = 1;
	sceKernelSuspendThread(sexy_thread_id);
	sceKernelSuspendThread(audio_thread_id);

	length = psf_info->length > 0 ? psf_info->length : 200000;
	if( psf_info->title ) strncpy(title, psf_info->title, 128);
	if( psf_info->game ) strncpy(album, psf_info->game, 128);
	if( psf_info->artist ) strncpy(artist, psf_info->artist, 128);
	if( psf_info->copyright ) strncpy(copyright, psf_info->copyright, 128);

	return 1;
}


void cleanup( void )
{
	if( psf_info != NULL ) {
		if( thread_paused ) {
			sceKernelResumeThread(sexy_thread_id);
		}

		sexy_thread_exit_flag = 1;
		sceKernelWaitThreadEnd(sexy_thread_id, 0);
		sceKernelDeleteThread(sexy_thread_id);

		sexy_freepsfinfo(psf_info);
		psf_info = 0;
		thread_paused = 0;
	}

	int i;
	for(i=0;i<BUFFER_COUNT;i++) free(sound_buffer[i]);
	free(sound_buffer);
	free(sound_buffer_ready);

	__psp_free_heap();
}

void get_song_title( char *filename, char **title, int *length )
{
}

void get_packet(void)
{
	switch( itable.in_packet->ID ) {
		case CMD_REQUEST_XSFLIBN:
			ex_load_rw((struct XSFLibN *)itable.in_packet->data);
			itable.in_packet->ID = CMD_FREE_XSFLIBN;
			break;
		case CMD_FREE_XSFLIBN:
			itable.in_packet->ID = NO_PACKET;
			break;
		case NO_PACKET:
		default:
			break;
	};
}

void send_packet(void)
{
	switch( itable.out_packet->ID ) {
		/* PLAYER COMMANDS */
		case CMD_SEND_VISUAL_BUFFER:
			/* TODO */
			itable.out_packet->data = _vbuf;
			itable.out_packet->size = 4096;
			break;
		case CMD_SEND_PLAYTIME:
			/* TODO */
			itable.out_packet->data = NULL;
			break;
		case CMD_SEND_TOTALSAMPLES:
			itable.out_packet->data = &total_samples;
			break;
		case CMD_PAUSE:
		case CMD_STOP:
			if(thread_paused == 0)
			{
				sceKernelSuspendThread(sexy_thread_id);
				thread_paused = 1;

				audio_thread_exit_flag = 1;
				sceKernelWaitThreadEnd(audio_thread_id, 0);
				sceKernelDeleteThread(audio_thread_id);
			}
			break;
		case CMD_RESUME:
			if(thread_paused == 1)
			{
				audio_thread_id = sceKernelCreateThread("audio_thread", audio_thread,
					16, 0x1000, PSP_THREAD_ATTR_USER, 0);
				audio_thread_exit_flag = 0;
				sceKernelStartThread(audio_thread_id, 0, 0);

				sceKernelResumeThread(sexy_thread_id);
				thread_paused = 0;
			}
			break;
		case CMD_VOLUP:
			/* TODO */
			break;
		case CMD_VOLDOWN:
			/* TODO */
			break;
		case CMD_SET_EQUALIZER:
			/* NOT IMPLEMENTED */
			break;

		/* song data */
		case SONG_TITLE:
			itable.out_packet->data = title;
			break;
		case SONG_ARTIST:
			itable.out_packet->data = artist;
			break;
		case SONG_ALBUM_GAME:
			itable.out_packet->data = album;
			break;
		case SONG_COPYRIGHT:
			itable.out_packet->data = copyright;
			break;
		case SONG_FORMAT:
			itable.out_packet->data = format;
			break;
		case SONG_LENGTH:
			itable.out_packet->data = &length;
			break;
		case SONG_SUBTUNES:
			itable.out_packet->data = &subtunes;
			break;

		/* audio info */
		case AUDIO_CHANNELS:
			itable.out_packet->data = &channels;
			break;
		case AUDIO_SAMPLERATE:
			itable.out_packet->data = &samplerate;
			break;
		case AUDIO_FORMAT:
			itable.out_packet->data = &aformat;
			break;
		case AUDIO_KBPS:
			itable.out_packet->data = &kbps;
			break;

		/* extra data */
		case ATTACHED_PICTURE:
			itable.out_packet->size = 0;
			itable.out_packet->data = NULL;
			break;
		case NO_PACKET:
		default:
			itable.out_packet->size = 0;
			itable.out_packet->data = NULL;
			break;
	};
}
