#ifndef STDCORE_H
#define STDCORE_H

/*

These are the routines required by libpogo to exist. They can either be provided
by the normal clibrary or by libcore.a which is the clib replacement part of pogo.
Applications only include this file in the latter case.

This file is also included by libpogo when compiling.

*/


#include "pogo/types.h"

#ifndef LIBPOGO
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#else

#ifdef __cplusplus
extern "C" {
#endif

#ifndef va_start

// Map stdargs to gcclibs implementation
typedef __builtin_va_list va_list; 
#define va_start(v,l) __builtin_stdarg_start((v),l)
#define va_end __builtin_va_end
#define va_arg __builtin_va_arg

#endif

#if (!defined NULL) && (!defined EXTERNAL_CLIB)
#define NULL 0
#endif

#if (!defined EOF) && (!defined EXTERNAL_CLIB)
#define EOF -1
#endif

void *memset(void *dest, int v, int l);
void *memmove(void *dst, const void *src, int l);
void *memcpy(void *dst, const void *src, int l);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, int n);
int strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, int n);
int memcmp(const char *s1, const char *s2, int n);

void *malloc(int x);
void *realloc(void *p, int l);
void free(void *x);
void *calloc(int x, int y);

#ifdef __cplusplus
}
#endif

#endif

#endif
