#ifndef _MEMORY_H_
#define _MEMORY_H_

#define MEM_STRUCTS

typedef struct _MemInfo
{
	uint32 size;
	uint32 *data;
} MemInfo;


typedef struct
{
	uint32 *base;
	int size;
	MemInfo *bottom;
	MemInfo *top;

} MemArea;


void memory_init();
uint32 *memory_alloc(MemArea *area, uint32 *mem, int size);
uint32 *memory_realloc(MemArea *area, uint32 *mem, int size);
uint32 *memory_free(MemArea *area, uint32 *mem);
int memory_avail(MemArea *area);

#ifdef MALLOC_DEBUG

void *_malloc(int x);
void *_malloc_fixed(void *ptr, int x);
void *_realloc(void *p, int l);
void _free(void *x);

extern void *mdbgptr;

#define malloc(x) (_dprintf("%s:%d %d bytes => %p\n", __FILE__, __LINE__, x, mdbgptr = _malloc(x)), mdbgptr )
#define realloc(p, l)  (_dprintf("%s:%d (%p)%d bytes => %p\n", __FILE__, __LINE__, p, l, mdbgptr = _realloc(p,l) ), mdbgptr )
#define free(p) _free(p)

#else

void *malloc(int x);
void *malloc_fixed(void *ptr, int x);
void *realloc(void *p, int l);
void free(void *x);
void *calloc(int x, int y);
#endif

// Should be renamed
void memory_setarea(int area);
int avail(void);

#endif /*_MEMORY_H_*/
