#ifndef IO_H
#define IO_H

#include "stdcore.h"
#include "device.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef void POGOFILE;

#define FD_STDIN 0
#define FD_STDOUT 1
#define FD_STDERR 2

POGOFILE *pogo_fopen(const char *name, const char *mode);
int pogo_fread(void *dest, int size, int count, POGOFILE *fp);
int pogo_fwrite(const void *src, int size, int count, POGOFILE *fp);
int pogo_fclose(POGOFILE *fp);
int pogo_ftell(POGOFILE *fp);
int pogo_fseek(POGOFILE *fp, int offset, int orgin);

extern POGOFILE *pogo_stdin;
extern POGOFILE *pogo_stdout;
extern POGOFILE *pogo_stderr;

//#define stdin ((POGOFILE *)0)
//#define stdout ((POGOFILE *)1)
//#define stderr ((POGOFILE *)2)

int pogo_printf(char *fmt, ...);
int pogo_dprintf(char *fmt, ...);

int pogo_putc( int c, POGOFILE *stream );
int pogo_putchar( int c );
int pogo_getc( POGOFILE *stream );
int pogo_getchar( void );

int pogo_fputs( char *string, POGOFILE *stream );
int pogo_puts( char *string );
char *pogo_gets( char *buffer );
char *pogo_fgets( char *string, int n, POGOFILE *stream );

int pogo_fputc(int c, POGOFILE *fp);
int pogo_fgetc(POGOFILE *fp);

int pogo_fprintf(POGOFILE *fp, char *fmt, ...);
int pogo_vfprintf(POGOFILE *fp, char *fmt, va_list vl);

//int rand(void);
//time_t time(time_t *t);
//void exit(int rc);
//int atexit(void *func);
//void abort(void);
//void srand(unsigned int s);

typedef void POGODIR;

struct pogo_dirent
{
	char *d_name;
	//uint32 d_size;
};

POGODIR *pogo_opendir(const char *name);
struct pogo_dirent *pogo_readdir(POGODIR *dir);
void pogo_closedir(POGODIR *dir);

#ifdef __cplusplus
}
#endif

#endif
