#ifndef POGOFONT_H
#define POGOFONT_H

#include "pogo/types.h"

typedef struct {
	uchar flags;
	signed char spacing;
	uchar first;
	uchar last;
	uchar charwidth;	// Only for space in proportional fonts
	uchar height;		// Height in pixels
	uint16 width;		// Real width of entire font in pixels - actual planar data is aligned up to nearest 32

	/* Non-disk part */
	char *name;
	uint16 *colors;
	uchar *pixels;		// Chunky data, width*height bytes
	uint16 *offsets;	// NULL for monospaced font
	int *sequences;
} Font;

/* Disk format

	- Font structure (First part)
	- width*height/8 bytes planar pixels
	- (last-first) 16bit offsets
*/

#define FFLG_PROPORTIONAL 1
#define FFLG_HIFONT 2
#define FFLG_COLOR 4
#define FFLG_TRANSP 8
#define FFLG_BOLD 16
#define FFLG_ITALIC 32
#define FFLG_UNICODE 64
#define FFLG_EXTENDED 128

#ifdef __cplusplus
extern "C" {
#endif

void font_settarget(void *dest, int width, int height, int flow);
Font *font_getdefault();

uchar font_putchar(Font *font, int c, int x, int y);
int font_text(Font *font, char *str, int x, int y);
int font_text_multi(Font **fontlist, int *current, char *str, int x, int y);

void font_setcolor(uint32 fg, uint32 bg);
Font *font_load(char *name);
void font_free(Font *font);
Font *font_memload(uchar *mem, char *name);
Font *font_dup(Font *font);

#ifdef __cplusplus
}
#endif
	
#endif
