#ifndef DEVICE_H
#define DEVICE_H

#include "stdcore.h"

#ifdef __cplusplus
extern "C" {
#endif


//#define PACKED __attribute__ ((packed))
#define PACKED

typedef struct
{
	char name[32];
	int size;
	int start;

} PACKED Romfile;

struct pogo_stat 
{
  uchar		st_dev;
  uint16	st_ino;
  uint16	st_mode;
  uchar		st_nlink;
  uchar		st_uid;
  uchar		st_gid;
  uchar		st_rdev;
  uint32	st_size;
  uint32	st_atimex;
  uint32	st_mtimex;
  uint32	st_ctimex; 
};


typedef struct {
	int (*open)(const char *name, int flags);
	int (*read)(int fd, void *dest, int size);
	int (*write)(int fd, const void *dest, int size);
	void (*close)(int fd);
	int (*lseek)(int fd, int offset, int origin);
	int (*ioctl)(int fd, int request, va_list vlist);
	int (*stat)(const char *path, struct pogo_stat *buffer);
	int (*remove)(const char *name);
	int (*rename)(const char *oldname, const char *newname);
	int (*dopen)(const char *name);
	int (*dread)(int fd, void *dest, int size);
	void (*dclose)(int fd);

} PogoDevice;

int pogo_device_register(PogoDevice *dev, char *name, void (*irqfunc)(void), int fd);

void pogo_device_init();

int pogo_open(const char *name, int flags);
int pogo_read(int fd, void *dest, int size);
int pogo_write(int fd, const void *dest, int size);
int pogo_close(int fd);
int pogo_lseek(int fd, int offset, int origin);
int pogo_tell(int fd);
int pogo_ioctl(int fd, int request, ...);
int pogo_remove(const char *name);
int pogo_stat(const char *name, struct pogo_stat *buffer);

int pogo_dopen(const char *name);
int pogo_dclose(int fd);
int pogo_dread(int fd, void *dest, int size);

void pogo_execv(const char *cmdname, const char *const *argv);
void pogo_execv_jump(const char *cmdname, const char *const *argv, void *jump);

#if (!defined SEEK_SET) && (!defined EXTERNAL_CLIB)

#define	SEEK_SET	0	/* set file offset to offset */
#define	SEEK_CUR	1	/* set file offset to current plus offset */
#define	SEEK_END	2	/* set file offset to EOF plus offset */
#define SEEK_MEM    3   /* Return memory position if a romfile */

#endif

#if (!defined O_RDONLY) && (!defined EXTERNAL_CLIB)

#define S_IFDIR 0x1000

#define O_RDONLY	0x0001 
#define O_WRONLY	0x0002 
#define O_RDWR		0x0003 
#define O_NBLOCK	0x0010 
#define O_APPEND	0x0100 
#define O_CREAT		0x0200 
#define O_TRUNC		0x0400 
#define O_NOWAIT	0x8000 

#endif

/* ioctl commands - TODO: Many obsolete definitions, possbile clib collisions */

/* Standard ioctl commands */
#define IO_GETMODE 1
#define IO_SETMODE 2
#define IO_GETPARAM 3
#define IO_SETPARAM 4

/* Keyboard ioctl commands */
#define KC_SETIMAGE 9
#define KC_GETSCREENOFFSET 10
#define KC_ADDHISTORY 5
#define KC_SETDICT 6
#define KC_BINDKEY 7
#define KC_SETCOMPLETION 8

/* SRAM ioctl commands */
#define SR_SETUSER 20
#define SR_GETUSER 21
#define SR_FREESPACE 22


#define KM_RAW 1
#define KM_SHOWKBD 2
#define KM_BLOCKED 4
#define KM_ECHO 8

#define RAWKEY_L 1
#define RAWKEY_R 2
#define RAWKEY_UP 3
#define RAWKEY_DOWN 4
#define RAWKEY_LEFT 5
#define RAWKEY_RIGHT 6
#define RAWKEY_START 7
#define RAWKEY_SELECT 8
#define RAWKEY_A 9
#define RAWKEY_B 10

#define CHAR_LEFT 241
#define CHAR_RIGHT 242
#define CHAR_LINEKILL 250

#ifdef __cplusplus
}
#endif


#endif
