#ifndef CORE_H
#define CORE_H

typedef unsigned int uint32;
typedef int int32;
typedef unsigned short uint16;
typedef short int16;
typedef unsigned char uchar;

typedef volatile unsigned int vuint32;
typedef volatile int vint32;
typedef volatile unsigned short vuint16;
typedef volatile short vint16;
typedef volatile unsigned char vuchar;

#ifndef NULL
#define NULL 0
#endif

#ifndef EOF
#define EOF (-1)
#endif

typedef int size_t;
#define difftime(t1,t0) (t1-t0)
#define assert(x) (void)(x)
#define CHAR_BIT      8
#define SCHAR_MIN   (-128)
#define SCHAR_MAX     127
#define UCHAR_MAX     0xff

extern int errno;

// Map stdargs to gcclibs implementation - should be in its own file
typedef __builtin_va_list va_list; 
#define va_start(v,l) __builtin_stdarg_start((v),l)
#define va_end __builtin_va_end
#define va_arg __builtin_va_arg


void *memset(void *dest, int v, int l);
void *memmove(void *dst, const void *src, int l);
void *memmove8(void *dst, const void *src, int l);
void *memcpy(void *dst, const void *src, int l);
void *memcpy8(void *dst, const void *src, int l);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, int n);
int strlen(const char *s);
char *strcpy(char *dst, const char *src);
char *strncpy(char *dst, const char *src, int n);
int memcmp(const char *s1, const char *s2, int n);

void Halt(void);
void set_ram_start(int i);

typedef uint32 time_t;
#define CLOCKS_PER_SEC 50
int clock(void);

struct tm
{
	uint16 tm_sec;     /* seconds */
	uint16 tm_min;     /* minutes */
	uint16 tm_hour;    /* hours */
	uint16 tm_mday;    /* day of the month */
	uint16 tm_mon;     /* month */
	uint16 tm_year;    /* year */
	uint16 tm_wday;    /* day of the week */
	//int     tm_yday;        /* day in the year */
	//int     tm_isdst;       /* daylight saving time */
};

time_t time(time_t *);
struct tm *time2(struct tm *dst);
struct tm *localtime(time_t t);

#define gmtime localtime

#define memmove8 memmove

#define CLOCKS_PER_SEC 50

int dprintf(char *fmt, ...);

void qsort(void *array, int count, int size, int cf(const void *a, const void *b));


#include "memory.h"

#endif
