#ifndef CONSOLE_H
#define CONSOLE_H

enum { CONWIN_FIXED, CONWIN_STREAM };

enum { CCOL_BLACK, CCOL_DARKRED, CCOL_DARKGREEN, CCOL_DARKYELLOW,
CCOL_DARKBLUE, CCOL_DARKPURPLE, CCOL_DARKCYAN, CCOL_DARKGRAY, 
CCOL_GRAY,  CCOL_RED, CCOL_GREEN, CCOL_YELLOW,
CCOL_BLUE, CCOL_PURPLE, CCOL_CYAN,
CCOL_WHITE = 15}; 

/* Console ioctl commands */
#define CC_GETTEXTWIDTH 5
#define CC_CLEAR 6
#define CC_GETHEIGHT 7
#define CC_LINESOUT 8
#define CC_SETFONT 9
#define CC_GETXY 10
#define CC_GETLINE 11
#define CC_GOTOXY 12
#define CC_GETFONT 13
#define CC_GETX 14
#define CC_GETY 15
#define CC_GETCHARWIDTH 16
#define CC_MARK 17
#define CC_ERASE 18
#define CC_SETCOLOR 19
#define CC_GETPOS 20
#define CC_SCROLL 21
#define CC_SETWIN 22
#define CC_OPENWIN 23
#define CC_CLOSEWIN 24
#define CC_RESIZEWIN 25
#define CC_MOVEWIN 26
#define CC_FLUSH 27
#define CC_SETMORECALLBACK 28
#define CC_RESETMORE 29

/* Parameters */
#define CM_LINEWRAP 1
#define CM_WORDWRAP 2

#ifdef __cplusplus
extern "C" {
#endif

void console_init();
void console_set_target(void *pixels, int stride);

#ifdef __cplusplus
}
#endif

#endif
