/**
 * @defgroup  as68 as68
 * @{
 *
 * MC68000 Macro Assembler.
 *
 * @section author AUTHOR
 *
 *   Copyright (C) 1993-2003 Vincent Penne and Benjamin Gerard
 *
 *   This program is free software.
 *
 * @section date DATE
 *
 *   2003
 *
 * @section synopsis SYNOPSIS
 *
 *   as68 [options] <in> [-o <out>] [-s <symbol>]
 *
 * @section description DESCRIPTION
 *
 *   as68 is a very fast Motorola 68000 macro assembler.
 *
 * @section options OPTIONS
 *
 *  @arg @b -r             Do not produce relocation table (default)
 *  @arg @b -R             Produce relocation table
 *  @arg @b -p             No position independant code check (default)
 *  @arg @b -P             Warning position dependant addressing mode
 *  @arg @b -v             Disable verbose
 *  @arg @b -V             Enable Verbose (default)
 *  @arg @b -b[Kbytes]     Change code buffer (Kbytes is a number of Kbyte)
 *  @arg @b -s <filename>  Set relocation table filename (def:<in>.rel)
 *  @arg @b -o <filename>  Set output filename (def:<in>.bin) 
 *
 *  @section syntax ASSEMBLER SYNTAX
 *
 *  as68 syntax is very close to hisoft genst(tm). 
 *  Except for some assembly directives are which are followed by a
 *  { ... } block. In other words it should be close enough to Motorola
 *  specifications.
 *
 *  @subsection macrosyntax MACRO SYNTAX
 *
 *    Following sample should demonstrate macro basic syntax.
 *  
 * @code
 * name MACRO
 * {
 * label_\\@:        ;\\@ is replaced by macro unic id (incremented number).
 *   move.l #\\1,\\2  ;\\1 is the first macro parameter, \\2 the second ...
 * }
 * @endcode
 *
 *  @subsection controldirective ASSEMBLER CONTROL DIRECTIVES
 *
 *    @arg @b ALIGN        [EXPR] Set align to given position
 *    @arg @b DEFAULT      [BYTE|WORD]  Set default opcode size
 *    @arg @b EVEN         Set align to next even position
 *    @arg @b IF           [EXPR] Start a conditionnal block
 *    @arg @b INCBIN       [FILE] Include binary file.
 *    @arg @b INCLUDE      [FILE] Include source file.
 *    @arg @b LOAD         [EXPR] Set load address (cross devel)
 *    @arg @b LS           [FILE] Load symbol
 *    @arg @b LST          [FILE] Load symbol 2!
 *    @arg @b ORG          [EXPR] Set assembly address.
 *    @arg @b PRINT        [EXPR] Output a message
 *    @arg @b RELOCATION   [on|off] Set relocation generation
 *    @arg @b REPEAT       Start a @b REPEAT ... @b UNTIL loop
 *    @arg @b RPT          as @b REPEAT
 *    @arg @b RSRESET      Reset current structure
 *    @arg @b RSSET        Add a field to current structure
 *    @arg @b RUN          [EXPR] Set run address (cross devel)
 *    @arg @b UNTIL cond   End a @b REPEAT ... @b UNTIL loop
 *    @arg @b WHILE        [EXPR] Start a while block
 *
 *
 * @subsection reloctable RELOCATION TABLE
 *
 *   Relocation table is a binary table containing the offset from the
 *   beginning of the long word (32bit) that need a relocation.
 *   Each offset is stored as a long word (obviously Motorola 32 bit
 *   big endian). The table ends by a offset equal to -1 (0xFFFFFFFF).
 *
 * @code
 * ;
 * ; Sample code to use as68 relocation table.
 * ;
 * ; a0: relocation table
 * ; a1: binary
 * reloc:
 *   move.l  (a0)+,d0
 *   cmp.l   #-1,d0
 *   beq.s   .finish
 *   add.l   a1,0(a1,d0.l)
 *   bra.s   reloc
 * .finish:
 *   rts        
 * @endcode
 *
 *
 * @subsection strippingbss STRIPING BSS
 *
 *   as68 does not handle sectionning. Anyway it assumes that BSS is all
 *   zeroed data at the end of the binary. Striping BSS means to remove
 *   this data even if it were not generated by a ds.x instruction.
 *
 *
 * @section bugs BUGS
 *
 *   Report to @e bug@sashipa.com.
 *
 *   @arg  Missing relocation.
 *   @arg  -P forces -R. @b org directive is disabled !!
 *   @arg  pea relatif PC, bugs with -P or -R
 *   @arg  symbol created by  xx = v are always lower case !
 *   @arg  label can not have an instruction name
 *   @arg  label can start at any column
 *   
 * @section seealso SEE ALSO
 *
 *   @e as68, @e debug68, @e info68, @e sc68, @e sourcer68, @e unice68
 *
 * @}
 */
