
#include "NoWChar.h"

size_t wcslen(const wchar_t *wcs)
{   
    const wchar_t* input = wcs;
    while (*input != L'\0')
        ++input;

    return input - wcs;
}

/* TODO - Move these to NoWCType.h */
int iswxdigit(wchar_t c)
{
    return (unsigned int)(c         - '0') < 10u  ||
           (unsigned int)((c | 0x20) - 'a') <  6u;
}

int iswdigit(wchar_t c) {
    return (unsigned int)(c - '0') < 10u;
}

int iswlower(wchar_t c) {
  return (unsigned int) (c - 'a') < 26u;
}

wchar_t towlower(wchar_t c) {
  if ( (unsigned int)(c - 'A') < 26u )
    c += 'a' - 'A';
  return c;
}

wchar_t towupper(wchar_t c) {
  if ( (unsigned int)(c - 'a') < 26u )
    c += 'A' - 'a';
  return c;
}


long int wcstol(const wchar_t *wcs, wchar_t **wcendp, int base)
{
    long result = 0,value;
	int sign = 1;

	if ( *wcs == L'-' ) {
		sign = -1;
		wcs++;
	}

	if (!base) {
		base = 10;
		if (*wcs == L'0') {
			base = 8;
			wcs++;
			if ((*wcs == L'x') && iswxdigit(wcs[1])) {
				wcs++;
				base = 16;
			}
		}
	}
	while (iswxdigit(*wcs) && (value = iswdigit(*wcs) ? *wcs-L'0' : (iswlower(*wcs)
	    ? towupper(*wcs) : *wcs)-L'A'+10) < base) {
		result = result*base + value;
		wcs++;
	}
	if (wcendp)
		*wcendp = (wchar_t *)wcs;
	return result * sign;
}

int wcscmp(const wchar_t *wcs1, const wchar_t *wcs2)
{
    while (*wcs1 == *wcs2)
    {
        if (*wcs1 == L'\0')
            return 0;
        wcs1++;
        wcs2++;
    }

    return *wcs1 - *wcs2;
}

int wcscasecmp(const wchar_t *wcs1, const wchar_t *wcs2)
{
    while (towlower(*wcs1) == towlower(*wcs2))
  	{
    		if (*wcs1 == L'\0')
      			return 0;
    		wcs1++;
    		wcs2++;
  	}
  	return towlower(*wcs1) - towlower(*wcs2);
}

int wcsncasecmp(const wchar_t *wcs1, const wchar_t *wcs2, size_t n)
{
    if (n == 0)
		return 0;
	do {
		if (towupper(*wcs1) != towupper(*wcs2++))
			return towupper(*wcs1) - towupper(*--wcs2);
		if (*wcs1++ == 0)
			break;
	} while (--n != 0);
	return 0;
}

wchar_t *wcschr(const wchar_t *wcs, wchar_t wc)
{
    while ((*wcs)!=0)
	{
		if ((*wcs)==wc)
		{
			return((wchar_t *)wcs);
		}
		wcs++;
	}
	return(NULL);
}

wchar_t *wcsrchr(const wchar_t *wcs, wchar_t wc)
{
    wchar_t *sp=(wchar_t *)0;
	while (*wcs != L'\0')
	{
		if (*wcs == wc) 
			sp = (wchar_t *)wcs;
		wcs++;
	}
	if (wc == L'\0')
		sp = (wchar_t *)wcs;
	return sp;
}

wchar_t *wcscpy(wchar_t *wcs1, const wchar_t *wcs2)
{
    wchar_t *save = wcs1;

    for (; (*wcs1 = *wcs2); ++wcs2, ++wcs1);
    return save;
}

size_t wcstombs(char *s, const wchar_t *wcs, size_t n)
{
    int i = n;

	while (--i >= 0) {
		if (!(*s++ = *wcs++))
			break;
	}
	return n - i - 1;
}

size_t mbstowcs(wchar_t *wcs, const char *s, size_t n)
{
    int i = n;

	while (--i >= 0) {
		if (!(*wcs++ = *s++))
			return n - i - 1;
	}
	return n - i;
}
