#include <cmath>
#include <stdio.h>

#include "game_logic.h"
#include "draw.h"
#include "panmines.h"

int main(int argc, char **argv)
{
	bool quit = false;
	
	printf("%s v%s\n", argv[0], VERSION);

	SDL_Init( SDL_INIT_VIDEO | SDL_INIT_JOYSTICK ); // |SDL_INIT_AUDIO
	// Init the JoyStick
#ifdef CAANOO
	if (SDL_NumJoysticks()>0) {
		SDL_JoystickEventState(SDL_ENABLE);
		SDL_Joystick *joystick = SDL_JoystickOpen(0);
	}
#endif

	GLScreen *s = new GLScreen();
	SDL_Event event;

	// Init the textures
	SDL_Color color	= {255,255,255,255};
	TTF_Font* bold	= TTF_OpenFont("data/LiberationMono-Bold.ttf", CELL_FSIZE);
	TTF_Font* med	= TTF_OpenFont("data/LiberationMono-Bold.ttf", floor((CELL_FSIZE+TIME_FSIZE)/2));
	TTF_Font* small	= TTF_OpenFont("data/LiberationMono-Regular.ttf", TIME_FSIZE);
	TTF_Font* lab	= TTF_OpenFont("data/LiberationMono-Regular.ttf", LABEL_FSIZE);
	// for the intDisplay/timeDisplay
	s->addTexture("s0",	TTF_RenderText_Blended(small, "0", color));
	s->addTexture("s1",	TTF_RenderText_Blended(small, "1", color));
	s->addTexture("s2",	TTF_RenderText_Blended(small, "2", color));
	s->addTexture("s3",	TTF_RenderText_Blended(small, "3", color));
	s->addTexture("s4",	TTF_RenderText_Blended(small, "4", color));
	s->addTexture("s5",	TTF_RenderText_Blended(small, "5", color));
	s->addTexture("s6",	TTF_RenderText_Blended(small, "6", color));
	s->addTexture("s7",	TTF_RenderText_Blended(small, "7", color));
	s->addTexture("s8",	TTF_RenderText_Blended(small, "8", color));
	s->addTexture("s9",	TTF_RenderText_Blended(small, "9", color));

	// difficultySwitch
	s->addTexture("M1",	TTF_RenderText_Blended(med, "1", color));
	s->addTexture("M2",	TTF_RenderText_Blended(med, "2", color));
	s->addTexture("M3",	TTF_RenderText_Blended(med, "3", color));
	s->addTexture("M?",	TTF_RenderText_Blended(med, "?", color));

	// label
	s->addTexture("time",	TTF_RenderText_Blended(lab, "Time", color));
	s->addTexture("highsc",	TTF_RenderText_Blended(lab, "High Score", color));
	s->addTexture("ml",	TTF_RenderText_Blended(lab, "Mines Left", color));
	s->addTexture("diff",	TTF_RenderText_Blended(lab, "Difficulty", color));

	// Dialog
	s->addTexture("WIN",	TTF_RenderText_Blended(bold, "You WON !", color));
	s->addTexture("LOSE",	TTF_RenderText_Blended(bold, "You LOSE!", color));

	// mines Counts
	s->addTexture("G1",	TTF_RenderText_Blended(bold, "1", color));
	s->addTexture("G2",	TTF_RenderText_Blended(bold, "2", color));
	s->addTexture("G3",	TTF_RenderText_Blended(bold, "3", color));
	s->addTexture("G4",	TTF_RenderText_Blended(bold, "4", color));
	s->addTexture("G5",	TTF_RenderText_Blended(bold, "5", color));
	s->addTexture("G6",	TTF_RenderText_Blended(bold, "6", color));
	s->addTexture("G7",	TTF_RenderText_Blended(bold, "7", color));
	s->addTexture("G8",	TTF_RenderText_Blended(bold, "8", color));
	TTF_CloseFont(lab);
	TTF_CloseFont(small);
	TTF_CloseFont(bold);

	// Init the Grid
	Grid *g = new Grid(s);
	g->reNew();

	while( quit == false ) {
		while( SDL_PollEvent( &event ) ) {
			switch(event.type) {
			case SDL_QUIT:
				quit = true;
			break;
			case SDL_KEYUP:
				switch( event.key.keysym.sym ){
				case SDLK_q:
				case SDLK_ESCAPE:
					quit = true;
				break;
				}
			break;
#ifdef CAANOO
			case SDL_JOYBUTTONUP:
				if (event.jbutton.button == 6)
					quit = true;
			break;
#endif
			}
			g->eventManager(&event);
		}
		
		g->updateInLoop();
		s->flip();
		SDL_Delay( 20 );
	}

	delete s;
	delete g;

	SDL_Quit();

	return 0;
}
