#ifndef __grid_h__
#define __grid_h__

#include "draw.h"
#include <SDL/SDL.h>


class Grid;

class Cell: public GLObject {
public:
	Cell(Grid *p, int posx, int posy, bool mine = false);
	bool mined();
	bool isFlaged();
	void setMined(bool m = true);
	void setValue();
	void setValue(int v);
	int  getValue();
	void reset();
	void clicked(bool f);
	bool isShown();

protected:
	void drawCell(int v);
	void drawMine(GLpoint a, int r1, int r2, GL_Color ci, GL_Color co, int prec = 10);
	void drawFlag(GLpoint a, int w, int h, GL_Color bg, GL_Color f, GL_Color b);
	void show();

private:
	int faceValue;
	int x;
	int y;
	bool haveMine;
	bool shown;
	bool flaged;
	Grid* parent;

};

class intDisplay: public GLObject {
public:
	intDisplay(GLScreen *s, int v=0);
	void setValue(int v);
	int getValue();
protected:
	int  value;
	void drawBox();
	void drawInt();
	GLScreen *getScreen();
	int  fontH;
private:
	GLScreen *s;
};

class timeDisplay: public intDisplay {
public:
	timeDisplay(GLScreen *s, int v=0);
	void start();
	void reset();
	void stop();
	void update();
	bool running();
	void setValue(int v);
private:
	void drawTime();
	Uint32 startTicks;
	bool started;
	GLScreen *s;
};

class highScore: public timeDisplay {
public:
	highScore(GLScreen *s, int v=DEFAULT_SCORE);
	void loadFrom(string fname = SCORE_FILE);
	void saveTo(string fname = SCORE_FILE);
	void setLevel(int level);
private:
	int level;
	int score[3];
	
	
};

class cursor: public GLObject {
public:
	cursor(GLfloat x, GLfloat y, GLfloat w, GLfloat h);
private:
	GLfloat w;
	GLfloat h;
};

class gridCursor: public cursor {
public:
	gridCursor(int posx, int posy);
	void setPos(int posx, int posy);
	int getPosX();
	int getPosY();
	void moveUp();
	void moveDown();
	void moveLeft();
	void moveRight();
private:
	int posx;
	int posy;
};

class faceButton: public GLObject {
public:
	faceButton(GLfloat x, GLfloat y, GLfloat w, GLfloat h, bool hap=true);
	void setHappy(bool h);
private:
	void drawSegments();
	void drawFace(GLpoint a, bool happy, int radius);
	GLfloat w;
	GLfloat h;
	bool happy;
};


class DigSwitch {
public:
	DigSwitch(GLScreen *s, GLfloat x, GLfloat y, GLfloat w, GLfloat h, bool dig=true);
	void setDig(bool d);
	void flipSwitch();
	bool shouldDig();
private:
	cursor*	cur;
	GLObject* ob;
	bool	dig;
	GLfloat x,y,h,w;
};

class DifficultySwitch {
public:
	DifficultySwitch(GLScreen *s, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
	void setDifficulty(int d);
	int  getDifficulty();
	void clicked(GLfloat x, GLfloat y);
	int  getMineCount();
private:
	cursor		*cur;
	GLObject	*ob;
	int		diff;
	GLfloat		x, y, h, w;
};

class dialog : public GLObject {
public:
	dialog(GLScreen *s);
	void hide();
	void showIsWin(bool win);
private:
	GLScreen	*s;
	int		w, h;
};

class Grid {
public:
	Grid(GLScreen *s);
	~Grid();
	void gen(int maxMines);
	Cell *getCell(int x, int y);
	void eventManager(SDL_Event *e);
	void updateInLoop();
	void endGame(bool win=false);
	void reNew();
	GLScreen	*s; //yep ugly, that's for the Cells, I didnt feeled like adding a pointer in each instance of Cell.
private:
	void reset();
	void clickCell(bool flag, int x, int y);
	void clicked(int x, int y);

	Cell		**g;
	timeDisplay	*timer;
	highScore	*highsc;
	intDisplay	*minesCnt;
	faceButton	*face;
	gridCursor	*cur;
	DigSwitch	*ds;
	dialog		*dia;
	DifficultySwitch *fs;
	bool		finished;
	int		keypress;
	Uint32		keyStartTicks;
	bool		mousePress;
	Uint32		mouseStartTicks;
};

#endif
