#ifndef __screen_h__
#define __screen_h__

#include "panmines.h"

#include <map>
#include <vector>
#include <string>

using namespace std;
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>
#ifdef HAVE_GLES
#include <GLES/gl.h>
#else
#include <GL/gl.h>
#endif


typedef struct{
	GLfloat x;
	GLfloat y;
	GLfloat z;
} GLpoint;

typedef struct{
	GLfloat r;
	GLfloat g;
	GLfloat b;
	GLfloat a;
} GL_Color;

class Texture {
public:
	Texture(SDL_Surface *s);
	~Texture();
	void bind();
	int w;
	int h;
private:
	void fromTexture(SDL_Surface *s);
	GL_Color c;
	GLuint texID;
};
typedef map<string,Texture*> TexMap;

class GLObject;
class Segment {
public:
	Segment(int d=0, GLenum m = GL_TRIANGLE_STRIP);
	~Segment();
	void setDotVtx(int id, GLfloat x, GLfloat y, GLfloat z);
	void setDotVtx(int id, GLpoint p);
	void setDotCol(int id, GLfloat r, GLfloat g, GLfloat b, GLfloat a);
	void setDotCol(int id, GL_Color c);
	void setDotTex(int id, GLfloat x, GLfloat y);
	void setAlpha(bool alpha = true);
	void setTexture(Texture *t);
	void setMode(GLenum m);
	void setColor(GL_Color c);
	void setThickness(int t);
	void moveBy(GLfloat x, GLfloat y, GLfloat z = 0);
	void draw();
private:
	GLenum	mode;
	int	dots;
	GLfloat *vtx;
	GLfloat *col;
	GLfloat *tex;
	GL_Color c;
	int	thickness;
	bool	haveAlpha;
	Texture *t;
};

class GLObject {
public:
	GLObject();
	GLObject(GLpoint p);
	GLObject(GLfloat x, GLfloat y, GLfloat z=0);
	~GLObject();
	void clear();
	void draw();
	void moveBy(GLfloat x, GLfloat y, GLfloat z = 0);
	void moveTo(GLfloat x, GLfloat y, GLfloat z = 0);
	void moveTo(GLpoint p);
	Segment *addTexture(GLpoint a, Texture* t);
	void addTextureCenter(GLpoint a, Texture* t);
	void addTexture(GLpoint a, Texture* t, GL_Color c);
	void addTextureCenter(GLpoint a, Texture* t, GL_Color c);
	void addTexture90(GLpoint a, Texture* t, GL_Color c);
	void addLine(GLpoint a, GLpoint b, GL_Color c, int thickness = 1);
	void addRect(GLpoint a, int w, int h, GL_Color c);
	void addDisc(GLpoint a, int r, GL_Color ci, GL_Color co, int from = 0, int to = 360, int prec = 2, int c_x = 0, int c_y = 0);
	void addArc(GLpoint a, int r, GL_Color c, int thickness=2, int from = 0, int to = 360, int prec = 2);
	void addBox(GLpoint a, int w, int h, GL_Color c);
	void addButton(GLpoint a, int w, int h, GL_Color ci, GL_Color co, int radiusPct = 20);
protected:
	vector<Segment*> segs;
	GLpoint pos;
};
typedef map<string,GLObject*> ObjectMap;


class GLScreen {
public:
	GLScreen();
	~GLScreen();
	void		addTexture(string id, SDL_Surface *s);
	void		addTexture(string id, Texture *t);
 	Texture*	getTexture(string id);
	void		addObject(string id, GLObject *o);
	GLObject*	getObject(string id);
	void		flip();

	void drawFaceButton(bool happy);

private:
	void drawCell(int x, int y, int v);
	void drawMine(GLpoint a, int r1, int r2, GL_Color ci, GL_Color co, int prec = 10);
	void drawFlag(GLpoint a, int w, int h, GL_Color bg, GL_Color f, GL_Color b);
	void drawFace(GLpoint a, bool happy, int radius=18);
	SDL_Surface*	sdl_screen;
	TexMap		tex;
	ObjectMap	obj;
};

#endif
