
#include <stdio.h>
#include <cmath>
#include <iostream>
#include <sstream>
#include <algorithm>
using namespace std;

#ifdef HAVE_GLES
#include <GLES/gl.h>
#include "eglport.h"
#define glClearDepth glClearDepthf
#define glOrtho glOrthof
#else
#include <GL/gl.h>
#endif

#include "draw.h"
#include "panmines.h"

#define glColor(c) glColor4f(c.r,c.g,c.b,c.a)
#define GLCOLOR(c) c.r, c.g, c.b, c.a

static __inline__ int p2(int o) {	// build next power of 2 number
	int v = 1;
	while (v < o)
		v <<= 1;
	return v;
}




void Texture::fromTexture(SDL_Surface *s) {
	GLuint t;
	this->w = p2(s->w);
	this->h = p2(s->h);
	SDL_Surface*	tmp = SDL_CreateRGBSurface(0, w, h, 32, 0,0,0,0);//0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000);
	SDL_BlitSurface(s, 0, tmp, 0);
	glGenTextures(1, &t);
	this->texID = t;
	glBindTexture(GL_TEXTURE_2D, this->texID);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tmp->pixels );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	SDL_FreeSurface(tmp);
	SDL_FreeSurface(s);
}

Texture::Texture(SDL_Surface *s) : texID(-1) {
	this->fromTexture(s);
}

Texture::~Texture() {
	GLuint t;
	if (this->texID>-1) {
		t = this->texID;
		glDeleteTextures(1, &t);
		this->texID=-1;
	}
}

void Texture::bind() {
	glBindTexture(GL_TEXTURE_2D, this->texID);
}






Segment::Segment(int d, GLenum m) : vtx(NULL), col(NULL), tex(NULL), dots(d), mode(m), t(NULL), thickness(1), haveAlpha(false) {
}

Segment::~Segment() {
	if (this->vtx != NULL)
		delete this->vtx;
	if (this->col != NULL)
		delete this->col;
	if (this->tex != NULL)
		delete this->tex;
}

void Segment::moveBy(GLfloat x, GLfloat y, GLfloat z) {
	for(int i=0;i<this->dots;i++) {
		this->vtx[3*i] += x;
		this->vtx[3*i+1] += y;
		this->vtx[3*i+2] += z;
	}
}

void Segment::setDotVtx(int id, GLfloat x, GLfloat y, GLfloat z) {
	if (this->vtx == NULL)
		this->vtx = (GLfloat*)malloc(sizeof(GLfloat)*3*this->dots);
	this->vtx[3*id] = x;
	this->vtx[3*id+1] = y;
	this->vtx[3*id+2] = z;
}

void Segment::setDotVtx(int id, GLpoint p) {
	if (this->vtx == NULL)
		this->vtx = (GLfloat*)malloc(sizeof(GLfloat)*3*this->dots);
	this->vtx[3*id] = p.x;
	this->vtx[3*id+1] = p.y;
	this->vtx[3*id+2] = p.z;
}

void Segment::setDotCol(int id, GLfloat r, GLfloat g, GLfloat b, GLfloat a) {
	if (this->col == NULL)
		this->col = (GLfloat*)malloc(sizeof(GLfloat)*4*this->dots);
	this->col[4*id] = r;
	this->col[4*id+1] = g;
	this->col[4*id+2] = b;
	this->col[4*id+3] = a;
	if (a<1.0f)
		this->setAlpha();
}

void Segment::setDotCol(int id, GL_Color c) {
	if (this->col == NULL)
		this->col = (GLfloat*)malloc(sizeof(GLfloat)*4*this->dots);
	this->col[4*id] = c.r;
	this->col[4*id+1] = c.g;
	this->col[4*id+2] = c.b;
	this->col[4*id+3] = c.a;
	if (c.a<1.0f)
		this->setAlpha();
}

void Segment::setDotTex(int id, GLfloat x, GLfloat y) {
	if (this->tex == NULL)
		this->tex = (GLfloat*)malloc(sizeof(GLfloat)*2*this->dots);
	this->tex[2*id] = x;
	this->tex[2*id+1] = y;
}

void Segment::setMode(GLenum m) {
	this->mode = m;
}

void Segment::setThickness(int t) {
	this->thickness = t;
}

void Segment::setAlpha(bool alpha) {
	this->haveAlpha = alpha;
}

void Segment::setColor(GL_Color c) {
	this->c = c;
	if (c.a<1.0f)
		this->setAlpha();
}

void Segment::setTexture(Texture *t) {
	this->t = t;
	this->setAlpha();
}

void Segment::draw() {
	if (this->vtx == NULL)
		return;
	if (this->haveAlpha)
		glEnable(GL_BLEND);
	if (this->t != NULL) {
		glEnable(GL_TEXTURE_2D);
		this->t->bind();
	}
	if (this->mode == GL_LINE_STRIP)
		glLineWidth(this->thickness);
	glEnableClientState(GL_VERTEX_ARRAY);
	if (this->col != NULL)
		glEnableClientState(GL_COLOR_ARRAY);
	else
		glColor(this->c);
	if (this->tex != NULL)
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	glVertexPointer(3, GL_FLOAT, 0, this->vtx);
	if (this->col != NULL)
		glColorPointer(4, GL_FLOAT, 0, this->col);
	if (this->tex != NULL)
		glTexCoordPointer(2, GL_FLOAT, 0, this->tex);
	glDrawArrays(this->mode,0,this->dots);

	if (this->tex != NULL)
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	if (this->col != NULL)
		glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_VERTEX_ARRAY);
	if (this->mode == GL_LINE_STRIP)
		glLineWidth(1);
	if (this->t != NULL)
		glDisable(GL_TEXTURE_2D);
	if (this->haveAlpha)
		glDisable(GL_BLEND);
}









GLObject::GLObject() {
	this->pos.x = 0;
	this->pos.y = 0;
	this->pos.z = 0;
}
GLObject::GLObject(GLpoint p) {
	this->pos.x = p.x;
	this->pos.y = p.y;
	this->pos.z = p.z;
}

GLObject::GLObject(GLfloat x, GLfloat y, GLfloat z) {
	this->pos.x = x;
	this->pos.y = y;
	this->pos.z = z;
}
GLObject::~GLObject() {
	this->segs.clear();
}

void GLObject::clear() {
	this->segs.clear();
}

void GLObject::draw() {
	for (int i=0; i<this->segs.size(); i++)
		this->segs[i]->draw();
}

void GLObject::moveBy(GLfloat x, GLfloat y, GLfloat z) {
	this->pos.x += x;
	this->pos.y += y;
	this->pos.z += z;
	for (int i=0; i<this->segs.size(); i++)
		this->segs[i]->moveBy(x, y, z);
}

void GLObject::moveTo(GLpoint p) {
	this->moveBy(p.x-this->pos.x, p.y-this->pos.y, p.z-this->pos.z);
}

void GLObject::moveTo(GLfloat x, GLfloat y, GLfloat z) {
	this->moveBy(x-this->pos.x, y-this->pos.y, z-this->pos.z);
}

/*
 * A +-----------+ B
 *   |\ H     G /|
 *   | +-------+ |
 *   | |       | |
 *   | +-------+ |
 *   |/ E     F \|
 * D +-----------+ C 
 *
 */

#define PT_A this->pos.x+a.x,						this->pos.y+a.y, this->pos.z+a.z
#define PT_b this->pos.x+b.x,						this->pos.y+b.y, this->pos.z+b.z
#define PT_B this->pos.x+a.x+w, 					this->pos.y+a.y, this->pos.z+a.z
#define PT_C this->pos.x+a.x+w, 					this->pos.y+a.y+h, this->pos.z+a.z
#define PT_D this->pos.x+a.x, 						this->pos.y+a.y+h, this->pos.z+a.z
#define PT_E this->pos.x+a.x+(GLfloat)floor(w*radiusPct/100)+1,		this->pos.y+a.y+(GLfloat)floor(h*(100-radiusPct)/100), this->pos.z+a.z
#define PT_F this->pos.x+a.x+(GLfloat)floor(w*(100-radiusPct)/100),	this->pos.y+a.y+(GLfloat)floor(h*(100-radiusPct)/100), this->pos.z+a.z
#define PT_G this->pos.x+a.x+(GLfloat)floor(w*(100-radiusPct)/100),	this->pos.y+a.y+(GLfloat)floor(h*radiusPct/100)+1, this->pos.z+a.z
#define PT_H this->pos.x+a.x+(GLfloat)floor(w*radiusPct/100)+1,		this->pos.y+a.y+(GLfloat)floor(h*radiusPct/100)+1, this->pos.z+a.z


void GLObject::addTexture90(GLpoint a, Texture* t, GL_Color c) {
	if (t == NULL) return;

	Segment *s = new Segment(4, GL_TRIANGLE_FAN);
	s->setDotVtx(0, this->pos.x+a.x,	this->pos.y+a.y,	this->pos.z+0); s->setDotTex(3, 0.0f, 0.0f);
	s->setDotVtx(1, this->pos.x+a.x + t->h, this->pos.y+a.y,	this->pos.z+0); s->setDotTex(0, 1.0f, 0.0f);
	s->setDotVtx(2, this->pos.x+a.x + t->h, this->pos.y+a.y + t->w, this->pos.z+0); s->setDotTex(1, 1.0f, 1.0f);
	s->setDotVtx(3, this->pos.x+a.x,	this->pos.y+a.y + t->w, this->pos.z+0); s->setDotTex(2, 0.0f, 1.0f);
	s->setTexture(t);
	s->setColor(c);
	this->segs.insert(this->segs.end(), s);
}
Segment * GLObject::addTexture(GLpoint a, Texture* t) {
	if (t == NULL) return NULL;

	Segment *s = new Segment(4, GL_TRIANGLE_FAN);
	s->setDotVtx(0, this->pos.x+a.x,	this->pos.y+a.y,	this->pos.z+0); s->setDotTex(0, 0.0f, 0.0f);
	s->setDotVtx(1, this->pos.x+a.x + t->w, this->pos.y+a.y,	this->pos.z+0); s->setDotTex(1, 1.0f, 0.0f);
	s->setDotVtx(2, this->pos.x+a.x + t->w, this->pos.y+a.y + t->h, this->pos.z+0); s->setDotTex(2, 1.0f, 1.0f);
	s->setDotVtx(3, this->pos.x+a.x,	this->pos.y+a.y + t->h, this->pos.z+0); s->setDotTex(3, 0.0f, 1.0f);
	s->setTexture(t);
	this->segs.insert(this->segs.end(), s);
	return s;
}

void GLObject::addTextureCenter(GLpoint a, Texture* t) {
	if (t == NULL) return;

	GLpoint d = {a.x-t->w/2, a.y-t->h/2, 0};
	this->addTexture(d,t);
}

void GLObject::addTexture(GLpoint a, Texture* t, GL_Color c) {
	if (t == NULL) return;

	Segment *s = this->addTexture(a,t);
	s->setColor(c);
}

void GLObject::addTextureCenter(GLpoint a, Texture* t, GL_Color c) {
	if (t == NULL) return;

	GLpoint d = {a.x-t->w/2, a.y-t->h/2, 0};
	this->addTexture(d,t,c);
}

void GLObject::addLine(GLpoint a, GLpoint b, GL_Color c, int thickness) {
	Segment *s = new Segment(2, GL_LINE_STRIP);
	s->setThickness(thickness);
	s->setColor(c);
	s->setDotVtx(0, PT_A);
	s->setDotVtx(1, PT_b);

	this->segs.insert(this->segs.end(), s);
}

void GLObject::addRect(GLpoint a, int w, int h, GL_Color c) {
	Segment *s = new Segment(4, GL_TRIANGLE_FAN);
	s->setColor(c);
	s->setDotVtx(0, PT_A);
	s->setDotVtx(1, PT_B);
	s->setDotVtx(2, PT_C);
	s->setDotVtx(3, PT_D);

	this->segs.insert(this->segs.end(), s);
}

void GLObject::addButton(GLpoint a, int w, int h, GL_Color ci, GL_Color co, int radiusPct) {
	Segment *s = new Segment(13);
	s->setDotVtx(0,  PT_A); s->setDotCol(0,  co);
	s->setDotVtx(1,  PT_H); s->setDotCol(1,  ci);
	s->setDotVtx(2,  PT_B); s->setDotCol(2,  co);
	s->setDotVtx(3,  PT_G); s->setDotCol(3,  ci);
	s->setDotVtx(4,  PT_C); s->setDotCol(4,  co);
	s->setDotVtx(5,  PT_F); s->setDotCol(5,  ci);
	s->setDotVtx(6,  PT_D); s->setDotCol(6,  co);
	s->setDotVtx(7,  PT_E); s->setDotCol(7,  ci);
	s->setDotVtx(8,  PT_A); s->setDotCol(8,  co);
	s->setDotVtx(9,  PT_H); s->setDotCol(9,  ci);
	s->setDotVtx(10, PT_E); s->setDotCol(10, ci);
	s->setDotVtx(11, PT_G); s->setDotCol(11, ci);
	s->setDotVtx(12, PT_F); s->setDotCol(12, ci);

	this->segs.insert(this->segs.end(), s);
}

void GLObject::addBox(GLpoint a, int w, int h, GL_Color col) {
	GLpoint b = {a.x,a.y+h,a.z};
	GLpoint c = {a.x+w,a.y+h,a.z};
	GLpoint d = {a.x+w,a.y,a.z};
	this->addLine(a,b,col,1);
	this->addLine(b,c,col,1);
	this->addLine(c,d,col,1);
	this->addLine(d,a,col,1);
}

void GLObject::addDisc(GLpoint a, int r, GL_Color ci, GL_Color co, int from, int to, int prec, int c_x, int c_y) {
	int faces = floor((to-from)/prec)+2;
	int j=1;
	Segment *s = new Segment(faces, GL_TRIANGLE_FAN);
	// Draw center point
	s->setDotVtx(0, this->pos.x+a.x+c_x, this->pos.y+a.y+c_y, this->pos.z+a.z); s->setDotCol(0,  ci);
	for(int i=from;i<=to&&j<faces;i+=prec,j++) {
		float angle	= i/DEGRAD;
		s->setDotVtx(j, this->pos.x+a.x+(r*sinf(angle)), this->pos.y+a.y+(r*cosf(angle)), this->pos.z+a.z); s->setDotCol(j,  co);
	}
	this->segs.insert(this->segs.end(), s);
}
/*
 * Button-ify ;)
	glEnable(GL_BLEND);
	this->addDisc(a, radius, {1,1,1,0.8}, {0,0,0,0},0,360,10,-radius/2,-radius/2);
	glDisable(GL_BLEND);
*/


void GLObject::addArc(GLpoint a, int r, GL_Color c, int thickness, int from, int to, int prec) {
	int pts = floor((to-from)/prec)+1;
	int j = 0;
	Segment *s = new Segment(pts, GL_LINE_STRIP);
	s->setColor(c);
	for(int i=from;i<=to&&j<pts;i+=prec,j++) {
		float angle	= i/DEGRAD;
		s->setDotVtx(j, this->pos.x+a.x+(r*sinf(angle)), this->pos.y+a.y+(r*cosf(angle)), this->pos.z+a.z);
	}
	this->segs.insert(this->segs.end(), s);
}















GLScreen::GLScreen() {
	// Init the Font System
	if (TTF_Init() == -1) {
		fprintf(stderr,"ERROR: Cannot initiate the font engine\n");
		SDL_Quit();
		exit(2);
	}

	// Init the GLScreen
#if defined(HAVE_GLES)
       	if (!EGL_Open())
		exit(1);
	this->sdl_screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, 0, SDL_SWSURFACE | SDL_FULLSCREEN );
	EGL_Init(4);
#else
	this->sdl_screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, 0, SDL_HWSURFACE | SDL_GL_DOUBLEBUFFER | SDL_OPENGL );
#endif
	if (!this->sdl_screen) {
		fprintf(stderr,"ERROR: Cannot allocate screen\n");
		SDL_Quit();
		exit(1);
	}

#if !defined(HAVE_GLES)
	SDL_WM_SetCaption( "Panmines", NULL );

	SDL_GL_SetAttribute(SDL_GL_RED_SIZE,		8);
	SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,		8);
	SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,		8);
	SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE,		8);

	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE,		16);
	SDL_GL_SetAttribute(SDL_GL_BUFFER_SIZE,		32);
#endif

	// set the view port
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glClearDepth(1.0f);
	glDisable( GL_DEPTH_TEST );
	glShadeModel( GL_SMOOTH );
	glBlendFunc( GL_ONE, GL_ONE );
	glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST );
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glViewport(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glOrtho(0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 1, -1);

	glMatrixMode(GL_MODELVIEW);

	glLoadIdentity();
}

GLScreen::~GLScreen() {
	this->tex.clear();
	this->obj.clear();
#if defined(HAVE_GLES)
	EGL_Destroy();
#endif
}

void GLScreen::flip() {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	ObjectMap::iterator i;
	for ( i=this->obj.begin() ; i != this->obj.end(); i++ )
		(*i).second->draw();
#if !defined(HAVE_GLES)
	SDL_GL_SwapBuffers();
#else
	EGL_SwapBuffers();
#endif
}

void GLScreen::addTexture(string id, Texture *t) {
	this->tex[id] = t;
}

void GLScreen::addTexture(string id, SDL_Surface *s) {
	this->tex[id] = new Texture(s);
}

Texture* GLScreen::getTexture(string id) {
	if (this->tex.find(id) == this->tex.end()) {
		this->tex.erase(this->tex.find(id));
		stringstream ss;
		TexMap::const_iterator i(this->tex.begin()), end(this->tex.end());
		for (;i!=end; i++)
		ss << "  " << i->first;
		cout << "WARNING " << id << " texture not found. Availables : " << ss.str() << endl;
		return NULL;
	}
	else
		return this->tex[id];
}

void GLScreen::addObject(string id, GLObject *o) {
	this->obj[id] = o;
}

GLObject* GLScreen::getObject(string id) {
	return this->obj[id];
}


