//  Copyright (c) 2001-2009 Hartmut Kaiser
//
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#if !defined(BOOST_SPIRIT_QI_UNUSED_SKIPPER_JUL_25_2009_0921AM)
#define BOOST_SPIRIT_QI_UNUSED_SKIPPER_JUL_25_2009_0921AM

#if defined(_MSC_VER)
#pragma once
#endif

#include <boost/spirit/home/support/unused.hpp>

namespace boost { namespace spirit { namespace qi { namespace detail
{
    template <typename Skipper>
    struct unused_skipper : unused_type
    {
        unused_skipper(Skipper const& skipper)
          : skipper(skipper) {}
        Skipper const& skipper;

    private:
        // silence MSVC warning C4512: assignment operator could not be generated
        unused_skipper& operator= (unused_skipper const&);
    };

    // If a surrounding lexeme[] directive was specified, the current
    // skipper is of the type unused_skipper. In this case we 
    // re-activate the skipper which was active before the skip[]
    // directive.
    template <typename Skipper>
    inline Skipper const& 
    get_skipper(unused_skipper<Skipper> const& u)
    {
        return u.skipper;
    }

    // If no surrounding lexeme[] directive was specified we keep what we got.
    template <typename Skipper>
    inline Skipper const& 
    get_skipper(Skipper const& u)
    {
        return u;
    }

}}}}

#endif
